package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VaultIssuerBuilder extends io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluentImpl<io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha3.VaultIssuer,io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerBuilder> {

    io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public VaultIssuerBuilder() {
        this(true);
    }

    public VaultIssuerBuilder(java.lang.Boolean validationEnabled) {
        this(new VaultIssuer(), validationEnabled);
    }

    public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent<?> fluent) {
        this(fluent, true);
    }

    public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new VaultIssuer(), validationEnabled);
    }

    public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.VaultIssuer instance) {
        this(fluent, instance, true);
    }

    public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.VaultIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuth(instance.getAuth()); 
        fluent.withCaBundle(instance.getCaBundle()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withPath(instance.getPath()); 
        fluent.withServer(instance.getServer()); 
        this.validationEnabled = validationEnabled; 
    }

    public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultIssuer instance) {
        this(instance,true);
    }

    public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuth(instance.getAuth()); 
        this.withCaBundle(instance.getCaBundle()); 
        this.withNamespace(instance.getNamespace()); 
        this.withPath(instance.getPath()); 
        this.withServer(instance.getServer()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.v1alpha3.EditableVaultIssuer build() {
        EditableVaultIssuer buildable = new EditableVaultIssuer(fluent.getAuth(),fluent.getCaBundle(),fluent.getNamespace(),fluent.getPath(),fluent.getServer());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VaultIssuerBuilder that = (VaultIssuerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
