/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.certmanager.api.model.v1alpha2.JKSKeystore;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class JKSKeystoreFluent<A extends JKSKeystoreFluent<A>>
extends BaseFluent<A> {
    private Boolean create;
    private SecretKeySelectorBuilder passwordSecretRef;

    public JKSKeystoreFluent() {
    }

    public JKSKeystoreFluent(JKSKeystore instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JKSKeystore instance) {
        JKSKeystore jKSKeystore = instance = instance != null ? instance : new JKSKeystore();
        if (instance != null) {
            this.withCreate(instance.getCreate());
            this.withPasswordSecretRef(instance.getPasswordSecretRef());
            this.withCreate(instance.getCreate());
            this.withPasswordSecretRef(instance.getPasswordSecretRef());
        }
    }

    public Boolean getCreate() {
        return this.create;
    }

    public A withCreate(Boolean create) {
        this.create = create;
        return (A)((Object)this);
    }

    public boolean hasCreate() {
        return this.create != null;
    }

    public SecretKeySelector buildPasswordSecretRef() {
        return this.passwordSecretRef != null ? this.passwordSecretRef.build() : null;
    }

    public A withPasswordSecretRef(SecretKeySelector passwordSecretRef) {
        this._visitables.get((Object)"passwordSecretRef").remove((Object)this.passwordSecretRef);
        if (passwordSecretRef != null) {
            this.passwordSecretRef = new SecretKeySelectorBuilder(passwordSecretRef);
            this._visitables.get((Object)"passwordSecretRef").add(this.passwordSecretRef);
        } else {
            this.passwordSecretRef = null;
            this._visitables.get((Object)"passwordSecretRef").remove((Object)this.passwordSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasPasswordSecretRef() {
        return this.passwordSecretRef != null;
    }

    public A withNewPasswordSecretRef(String key, String name) {
        return this.withPasswordSecretRef(new SecretKeySelector(key, name));
    }

    public PasswordSecretRefNested<A> withNewPasswordSecretRef() {
        return new PasswordSecretRefNested(null);
    }

    public PasswordSecretRefNested<A> withNewPasswordSecretRefLike(SecretKeySelector item) {
        return new PasswordSecretRefNested(item);
    }

    public PasswordSecretRefNested<A> editPasswordSecretRef() {
        return this.withNewPasswordSecretRefLike(Optional.ofNullable(this.buildPasswordSecretRef()).orElse(null));
    }

    public PasswordSecretRefNested<A> editOrNewPasswordSecretRef() {
        return this.withNewPasswordSecretRefLike(Optional.ofNullable(this.buildPasswordSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public PasswordSecretRefNested<A> editOrNewPasswordSecretRefLike(SecretKeySelector item) {
        return this.withNewPasswordSecretRefLike(Optional.ofNullable(this.buildPasswordSecretRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JKSKeystoreFluent that = (JKSKeystoreFluent)((Object)o);
        if (!Objects.equals(this.create, that.create)) {
            return false;
        }
        return Objects.equals((Object)this.passwordSecretRef, (Object)that.passwordSecretRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.create, this.passwordSecretRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.create != null) {
            sb.append("create:");
            sb.append(this.create + ",");
        }
        if (this.passwordSecretRef != null) {
            sb.append("passwordSecretRef:");
            sb.append((Object)this.passwordSecretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withCreate() {
        return this.withCreate(true);
    }

    public class PasswordSecretRefNested<N>
    extends SecretKeySelectorFluent<PasswordSecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        PasswordSecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)JKSKeystoreFluent.this.withPasswordSecretRef(this.builder.build());
        }

        public N endPasswordSecretRef() {
            return this.and();
        }
    }
}

