/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.CAIssuer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CAIssuerFluent<A extends CAIssuerFluent<A>>
extends BaseFluent<A> {
    private List<String> crlDistributionPoints = new ArrayList<String>();
    private List<String> ocspServers = new ArrayList<String>();
    private String secretName;

    public CAIssuerFluent() {
    }

    public CAIssuerFluent(CAIssuer instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CAIssuer instance) {
        CAIssuer cAIssuer = instance = instance != null ? instance : new CAIssuer();
        if (instance != null) {
            this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
            this.withOcspServers(instance.getOcspServers());
            this.withSecretName(instance.getSecretName());
            this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
            this.withOcspServers(instance.getOcspServers());
            this.withSecretName(instance.getSecretName());
        }
    }

    public A addToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)((Object)this);
    }

    public A setToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)((Object)this);
    }

    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCrlDistributionPoints() {
        return this.crlDistributionPoints;
    }

    public String getCrlDistributionPoint(int index) {
        return this.crlDistributionPoints.get(index);
    }

    public String getFirstCrlDistributionPoint() {
        return this.crlDistributionPoints.get(0);
    }

    public String getLastCrlDistributionPoint() {
        return this.crlDistributionPoints.get(this.crlDistributionPoints.size() - 1);
    }

    public String getMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCrlDistributionPoints(List<String> crlDistributionPoints) {
        if (crlDistributionPoints != null) {
            this.crlDistributionPoints = new ArrayList<String>();
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        } else {
            this.crlDistributionPoints = null;
        }
        return (A)((Object)this);
    }

    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
            this._visitables.remove((Object)"crlDistributionPoints");
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    public A addToOcspServers(int index, String item) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        this.ocspServers.add(index, item);
        return (A)((Object)this);
    }

    public A setToOcspServers(int index, String item) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        this.ocspServers.set(index, item);
        return (A)((Object)this);
    }

    public A addToOcspServers(String ... items) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ocspServers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOcspServers(Collection<String> items) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ocspServers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOcspServers(String ... items) {
        if (this.ocspServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ocspServers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOcspServers(Collection<String> items) {
        if (this.ocspServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ocspServers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOcspServers() {
        return this.ocspServers;
    }

    public String getOcspServer(int index) {
        return this.ocspServers.get(index);
    }

    public String getFirstOcspServer() {
        return this.ocspServers.get(0);
    }

    public String getLastOcspServer() {
        return this.ocspServers.get(this.ocspServers.size() - 1);
    }

    public String getMatchingOcspServer(Predicate<String> predicate) {
        for (String item : this.ocspServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOcspServer(Predicate<String> predicate) {
        for (String item : this.ocspServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOcspServers(List<String> ocspServers) {
        if (ocspServers != null) {
            this.ocspServers = new ArrayList<String>();
            for (String item : ocspServers) {
                this.addToOcspServers(item);
            }
        } else {
            this.ocspServers = null;
        }
        return (A)((Object)this);
    }

    public A withOcspServers(String ... ocspServers) {
        if (this.ocspServers != null) {
            this.ocspServers.clear();
            this._visitables.remove((Object)"ocspServers");
        }
        if (ocspServers != null) {
            for (String item : ocspServers) {
                this.addToOcspServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOcspServers() {
        return this.ocspServers != null && !this.ocspServers.isEmpty();
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CAIssuerFluent that = (CAIssuerFluent)((Object)o);
        if (!Objects.equals(this.crlDistributionPoints, that.crlDistributionPoints)) {
            return false;
        }
        if (!Objects.equals(this.ocspServers, that.ocspServers)) {
            return false;
        }
        return Objects.equals(this.secretName, that.secretName);
    }

    public int hashCode() {
        return Objects.hash(this.crlDistributionPoints, this.ocspServers, this.secretName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints + ",");
        }
        if (this.ocspServers != null && !this.ocspServers.isEmpty()) {
            sb.append("ocspServers:");
            sb.append(this.ocspServers + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName);
        }
        sb.append("}");
        return sb.toString();
    }
}

