/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.certmanager.api.model.acme.v1alpha2.OrderSpec;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OrderSpecFluent<A extends OrderSpecFluent<A>>
extends BaseFluent<A> {
    private String commonName;
    private String csr;
    private List<String> dnsNames = new ArrayList<String>();
    private Duration duration;
    private List<String> ipAddresses = new ArrayList<String>();
    private ObjectReferenceBuilder issuerRef;

    public OrderSpecFluent() {
    }

    public OrderSpecFluent(OrderSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OrderSpec instance) {
        OrderSpec orderSpec = instance = instance != null ? instance : new OrderSpec();
        if (instance != null) {
            this.withCommonName(instance.getCommonName());
            this.withCsr(instance.getCsr());
            this.withDnsNames(instance.getDnsNames());
            this.withDuration(instance.getDuration());
            this.withIpAddresses(instance.getIpAddresses());
            this.withIssuerRef(instance.getIssuerRef());
            this.withCommonName(instance.getCommonName());
            this.withCsr(instance.getCsr());
            this.withDnsNames(instance.getDnsNames());
            this.withDuration(instance.getDuration());
            this.withIpAddresses(instance.getIpAddresses());
            this.withIssuerRef(instance.getIssuerRef());
        }
    }

    public String getCommonName() {
        return this.commonName;
    }

    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)((Object)this);
    }

    public boolean hasCommonName() {
        return this.commonName != null;
    }

    public String getCsr() {
        return this.csr;
    }

    public A withCsr(String csr) {
        this.csr = csr;
        return (A)((Object)this);
    }

    public boolean hasCsr() {
        return this.csr != null;
    }

    public A addToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDnsNames(String ... items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public String getDnsName(int index) {
        return this.dnsNames.get(index);
    }

    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)((Object)this);
    }

    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
            this._visitables.remove((Object)"dnsNames");
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public A addToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public String getIpAddress(int index) {
        return this.ipAddresses.get(index);
    }

    public String getFirstIpAddress() {
        return this.ipAddresses.get(0);
    }

    public String getLastIpAddress() {
        return this.ipAddresses.get(this.ipAddresses.size() - 1);
    }

    public String getMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpAddresses(List<String> ipAddresses) {
        if (ipAddresses != null) {
            this.ipAddresses = new ArrayList<String>();
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        } else {
            this.ipAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
            this._visitables.remove((Object)"ipAddresses");
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrderSpecFluent that = (OrderSpecFluent)((Object)o);
        if (!Objects.equals(this.commonName, that.commonName)) {
            return false;
        }
        if (!Objects.equals(this.csr, that.csr)) {
            return false;
        }
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.ipAddresses, that.ipAddresses)) {
            return false;
        }
        return Objects.equals((Object)this.issuerRef, (Object)that.issuerRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commonName, this.csr, this.dnsNames, this.duration, this.ipAddresses, this.issuerRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commonName != null) {
            sb.append("commonName:");
            sb.append(this.commonName + ",");
        }
        if (this.csr != null) {
            sb.append("csr:");
            sb.append(this.csr + ",");
        }
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.ipAddresses != null && !this.ipAddresses.isEmpty()) {
            sb.append("ipAddresses:");
            sb.append(this.ipAddresses + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)this.issuerRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)OrderSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

