/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorization;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ACMEAuthorizationFluent<A extends ACMEAuthorizationFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ACMEChallengeBuilder> challenges = new ArrayList();
    private String identifier;
    private String initialState;
    private String url;
    private Boolean wildcard;

    public ACMEAuthorizationFluent() {
    }

    public ACMEAuthorizationFluent(ACMEAuthorization instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ACMEAuthorization instance) {
        ACMEAuthorization aCMEAuthorization = instance = instance != null ? instance : new ACMEAuthorization();
        if (instance != null) {
            this.withChallenges(instance.getChallenges());
            this.withIdentifier(instance.getIdentifier());
            this.withInitialState(instance.getInitialState());
            this.withUrl(instance.getUrl());
            this.withWildcard(instance.getWildcard());
            this.withChallenges(instance.getChallenges());
            this.withIdentifier(instance.getIdentifier());
            this.withInitialState(instance.getInitialState());
            this.withUrl(instance.getUrl());
            this.withWildcard(instance.getWildcard());
        }
    }

    public A addToChallenges(int index, ACMEChallenge item) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
        if (index < 0 || index >= this.challenges.size()) {
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        } else {
            this._visitables.get((Object)"challenges").add(index, builder);
            this.challenges.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToChallenges(int index, ACMEChallenge item) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
        if (index < 0 || index >= this.challenges.size()) {
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        } else {
            this._visitables.get((Object)"challenges").set(index, builder);
            this.challenges.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToChallenges(ACMEChallenge ... items) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToChallenges(Collection<ACMEChallenge> items) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromChallenges(ACMEChallenge ... items) {
        if (this.challenges == null) {
            return (A)((Object)this);
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").remove((Object)builder);
            this.challenges.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromChallenges(Collection<ACMEChallenge> items) {
        if (this.challenges == null) {
            return (A)((Object)this);
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").remove((Object)builder);
            this.challenges.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromChallenges(Predicate<ACMEChallengeBuilder> predicate) {
        if (this.challenges == null) {
            return (A)((Object)this);
        }
        Iterator<ACMEChallengeBuilder> each = this.challenges.iterator();
        List visitables = this._visitables.get((Object)"challenges");
        while (each.hasNext()) {
            ACMEChallengeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ACMEChallenge> buildChallenges() {
        return this.challenges != null ? ACMEAuthorizationFluent.build(this.challenges) : null;
    }

    public ACMEChallenge buildChallenge(int index) {
        return this.challenges.get(index).build();
    }

    public ACMEChallenge buildFirstChallenge() {
        return this.challenges.get(0).build();
    }

    public ACMEChallenge buildLastChallenge() {
        return this.challenges.get(this.challenges.size() - 1).build();
    }

    public ACMEChallenge buildMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        for (ACMEChallengeBuilder item : this.challenges) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        for (ACMEChallengeBuilder item : this.challenges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withChallenges(List<ACMEChallenge> challenges) {
        if (this.challenges != null) {
            this._visitables.get((Object)"challenges").clear();
        }
        if (challenges != null) {
            this.challenges = new ArrayList();
            for (ACMEChallenge item : challenges) {
                this.addToChallenges(item);
            }
        } else {
            this.challenges = null;
        }
        return (A)((Object)this);
    }

    public A withChallenges(ACMEChallenge ... challenges) {
        if (this.challenges != null) {
            this.challenges.clear();
            this._visitables.remove((Object)"challenges");
        }
        if (challenges != null) {
            for (ACMEChallenge item : challenges) {
                this.addToChallenges(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasChallenges() {
        return this.challenges != null && !this.challenges.isEmpty();
    }

    public A addNewChallenge(String token, String type, String url) {
        return this.addToChallenges(new ACMEChallenge(token, type, url));
    }

    public ChallengesNested<A> addNewChallenge() {
        return new ChallengesNested(-1, null);
    }

    public ChallengesNested<A> addNewChallengeLike(ACMEChallenge item) {
        return new ChallengesNested(-1, item);
    }

    public ChallengesNested<A> setNewChallengeLike(int index, ACMEChallenge item) {
        return new ChallengesNested(index, item);
    }

    public ChallengesNested<A> editChallenge(int index) {
        if (this.challenges.size() <= index) {
            throw new RuntimeException("Can't edit challenges. Index exceeds size.");
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    public ChallengesNested<A> editFirstChallenge() {
        if (this.challenges.size() == 0) {
            throw new RuntimeException("Can't edit first challenges. The list is empty.");
        }
        return this.setNewChallengeLike(0, this.buildChallenge(0));
    }

    public ChallengesNested<A> editLastChallenge() {
        int index = this.challenges.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last challenges. The list is empty.");
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    public ChallengesNested<A> editMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.challenges.size(); ++i) {
            if (!predicate.test(this.challenges.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching challenges. No match found.");
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public A withIdentifier(String identifier) {
        this.identifier = identifier;
        return (A)((Object)this);
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public A withInitialState(String initialState) {
        this.initialState = initialState;
        return (A)((Object)this);
    }

    public boolean hasInitialState() {
        return this.initialState != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public A withWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
        return (A)((Object)this);
    }

    public boolean hasWildcard() {
        return this.wildcard != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ACMEAuthorizationFluent that = (ACMEAuthorizationFluent)((Object)o);
        if (!Objects.equals(this.challenges, that.challenges)) {
            return false;
        }
        if (!Objects.equals(this.identifier, that.identifier)) {
            return false;
        }
        if (!Objects.equals(this.initialState, that.initialState)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.wildcard, that.wildcard);
    }

    public int hashCode() {
        return Objects.hash(this.challenges, this.identifier, this.initialState, this.url, this.wildcard, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.challenges != null && !this.challenges.isEmpty()) {
            sb.append("challenges:");
            sb.append(this.challenges + ",");
        }
        if (this.identifier != null) {
            sb.append("identifier:");
            sb.append(this.identifier + ",");
        }
        if (this.initialState != null) {
            sb.append("initialState:");
            sb.append(this.initialState + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.wildcard != null) {
            sb.append("wildcard:");
            sb.append(this.wildcard);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withWildcard() {
        return this.withWildcard(true);
    }

    public class ChallengesNested<N>
    extends ACMEChallengeFluent<ChallengesNested<N>>
    implements Nested<N> {
        ACMEChallengeBuilder builder;
        int index;

        ChallengesNested(int index, ACMEChallenge item) {
            this.index = index;
            this.builder = new ACMEChallengeBuilder(this, item);
        }

        public N and() {
            return (N)ACMEAuthorizationFluent.this.setToChallenges(this.index, this.builder.build());
        }

        public N endChallenge() {
            return this.and();
        }
    }
}

