package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VenafiIssuerBuilder extends VenafiIssuerFluent<VenafiIssuerBuilder> implements VisitableBuilder<VenafiIssuer,VenafiIssuerBuilder>{
  public VenafiIssuerBuilder() {
    this(new VenafiIssuer());
  }
  
  public VenafiIssuerBuilder(VenafiIssuerFluent<?> fluent) {
    this(fluent, new VenafiIssuer());
  }
  
  public VenafiIssuerBuilder(VenafiIssuerFluent<?> fluent,VenafiIssuer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VenafiIssuerBuilder(VenafiIssuer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VenafiIssuerFluent<?> fluent;
  
  public VenafiIssuer build() {
    VenafiIssuer buildable = new VenafiIssuer(fluent.buildCloud(),fluent.buildTpp(),fluent.getZone());
    return buildable;
  }
  

}