package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VaultIssuerFluent<A extends VaultIssuerFluent<A>> extends BaseFluent<A>{
  public VaultIssuerFluent() {
  }
  
  public VaultIssuerFluent(VaultIssuer instance) {
    this.copyInstance(instance);
  }
  private VaultAuthBuilder auth;
  private String caBundle;
  private String namespace;
  private String path;
  private String server;
  
  protected void copyInstance(VaultIssuer instance) {
    instance = (instance != null ? instance : new VaultIssuer());
  
    if (instance != null) {
        this.withAuth(instance.getAuth());
        this.withCaBundle(instance.getCaBundle());
        this.withNamespace(instance.getNamespace());
        this.withPath(instance.getPath());
        this.withServer(instance.getServer());
        this.withAuth(instance.getAuth());
        this.withCaBundle(instance.getCaBundle());
        this.withNamespace(instance.getNamespace());
        this.withPath(instance.getPath());
        this.withServer(instance.getServer());
      }
  }
  
  public VaultAuth buildAuth() {
    return this.auth!=null ?this.auth.build():null;
  }
  
  public A withAuth(VaultAuth auth) {
    _visitables.get("auth").remove(this.auth);
    if (auth!=null){ this.auth= new VaultAuthBuilder(auth); _visitables.get("auth").add(this.auth);} else { this.auth = null; _visitables.get("auth").remove(this.auth); } return (A) this;
  }
  
  public boolean hasAuth() {
    return this.auth != null;
  }
  
  public AuthNested<A> withNewAuth() {
    return new AuthNested(null);
  }
  
  public AuthNested<A> withNewAuthLike(VaultAuth item) {
    return new AuthNested(item);
  }
  
  public AuthNested<A> editAuth() {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(null));
  }
  
  public AuthNested<A> editOrNewAuth() {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(new VaultAuthBuilder().build()));
  }
  
  public AuthNested<A> editOrNewAuthLike(VaultAuth item) {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(item));
  }
  
  public String getCaBundle() {
    return this.caBundle;
  }
  
  public A withCaBundle(String caBundle) {
    this.caBundle=caBundle; return (A) this;
  }
  
  public boolean hasCaBundle() {
    return this.caBundle != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public String getServer() {
    return this.server;
  }
  
  public A withServer(String server) {
    this.server=server; return (A) this;
  }
  
  public boolean hasServer() {
    return this.server != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VaultIssuerFluent that = (VaultIssuerFluent) o;
    if (!java.util.Objects.equals(auth, that.auth)) return false;
  
    if (!java.util.Objects.equals(caBundle, that.caBundle)) return false;
  
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
  
    if (!java.util.Objects.equals(path, that.path)) return false;
  
    if (!java.util.Objects.equals(server, that.server)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(auth,  caBundle,  namespace,  path,  server,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (auth != null) { sb.append("auth:"); sb.append(auth + ","); }
    if (caBundle != null) { sb.append("caBundle:"); sb.append(caBundle + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (server != null) { sb.append("server:"); sb.append(server); }
    sb.append("}");
    return sb.toString();
  }
  public class AuthNested<N> extends VaultAuthFluent<AuthNested<N>> implements Nested<N>{
    AuthNested(VaultAuth item) {
      this.builder = new VaultAuthBuilder(this, item);
    }
    VaultAuthBuilder builder;
    
    public N and() {
      return (N) VaultIssuerFluent.this.withAuth(builder.build());
    }
    
    public N endAuth() {
      return and();
    }
    
  
  }

}