package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IssuerStatusBuilder extends IssuerStatusFluent<IssuerStatusBuilder> implements VisitableBuilder<IssuerStatus,IssuerStatusBuilder>{
  public IssuerStatusBuilder() {
    this(new IssuerStatus());
  }
  
  public IssuerStatusBuilder(IssuerStatusFluent<?> fluent) {
    this(fluent, new IssuerStatus());
  }
  
  public IssuerStatusBuilder(IssuerStatusFluent<?> fluent,IssuerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IssuerStatusBuilder(IssuerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IssuerStatusFluent<?> fluent;
  
  public IssuerStatus build() {
    IssuerStatus buildable = new IssuerStatus(fluent.buildAcme(),fluent.buildConditions());
    return buildable;
  }
  

}