package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertificateStatusFluent<A extends CertificateStatusFluent<A>> extends BaseFluent<A>{
  public CertificateStatusFluent() {
  }
  
  public CertificateStatusFluent(CertificateStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CertificateConditionBuilder> conditions = new ArrayList<CertificateConditionBuilder>();
  private String lastFailureTime;
  private String nextPrivateKeySecretName;
  private String notAfter;
  private String notBefore;
  private String renewalTime;
  private Integer revision;
  
  protected void copyInstance(CertificateStatus instance) {
    instance = (instance != null ? instance : new CertificateStatus());
  
    if (instance != null) {
        this.withConditions(instance.getConditions());
        this.withLastFailureTime(instance.getLastFailureTime());
        this.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName());
        this.withNotAfter(instance.getNotAfter());
        this.withNotBefore(instance.getNotBefore());
        this.withRenewalTime(instance.getRenewalTime());
        this.withRevision(instance.getRevision());
        this.withConditions(instance.getConditions());
        this.withLastFailureTime(instance.getLastFailureTime());
        this.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName());
        this.withNotAfter(instance.getNotAfter());
        this.withNotBefore(instance.getNotBefore());
        this.withRenewalTime(instance.getRenewalTime());
        this.withRevision(instance.getRevision());
      }
  }
  
  public A addToConditions(int index,CertificateCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    CertificateConditionBuilder builder = new CertificateConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,CertificateCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    CertificateConditionBuilder builder = new CertificateConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<CertificateCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition... items) {
    if (this.conditions == null) return (A)this;
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<CertificateCondition> items) {
    if (this.conditions == null) return (A)this;
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<CertificateConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<CertificateConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      CertificateConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CertificateCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  
  public CertificateCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public CertificateCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public CertificateCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public CertificateCondition buildMatchingCondition(Predicate<CertificateConditionBuilder> predicate) {
    for (CertificateConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingCondition(Predicate<CertificateConditionBuilder> predicate) {
    for (CertificateConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConditions(List<CertificateCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (CertificateCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  
  public A withConditions(io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (CertificateCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(CertificateCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,CertificateCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<CertificateConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public String getLastFailureTime() {
    return this.lastFailureTime;
  }
  
  public A withLastFailureTime(String lastFailureTime) {
    this.lastFailureTime=lastFailureTime; return (A) this;
  }
  
  public boolean hasLastFailureTime() {
    return this.lastFailureTime != null;
  }
  
  public String getNextPrivateKeySecretName() {
    return this.nextPrivateKeySecretName;
  }
  
  public A withNextPrivateKeySecretName(String nextPrivateKeySecretName) {
    this.nextPrivateKeySecretName=nextPrivateKeySecretName; return (A) this;
  }
  
  public boolean hasNextPrivateKeySecretName() {
    return this.nextPrivateKeySecretName != null;
  }
  
  public String getNotAfter() {
    return this.notAfter;
  }
  
  public A withNotAfter(String notAfter) {
    this.notAfter=notAfter; return (A) this;
  }
  
  public boolean hasNotAfter() {
    return this.notAfter != null;
  }
  
  public String getNotBefore() {
    return this.notBefore;
  }
  
  public A withNotBefore(String notBefore) {
    this.notBefore=notBefore; return (A) this;
  }
  
  public boolean hasNotBefore() {
    return this.notBefore != null;
  }
  
  public String getRenewalTime() {
    return this.renewalTime;
  }
  
  public A withRenewalTime(String renewalTime) {
    this.renewalTime=renewalTime; return (A) this;
  }
  
  public boolean hasRenewalTime() {
    return this.renewalTime != null;
  }
  
  public Integer getRevision() {
    return this.revision;
  }
  
  public A withRevision(Integer revision) {
    this.revision=revision; return (A) this;
  }
  
  public boolean hasRevision() {
    return this.revision != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateStatusFluent that = (CertificateStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
  
    if (!java.util.Objects.equals(lastFailureTime, that.lastFailureTime)) return false;
  
    if (!java.util.Objects.equals(nextPrivateKeySecretName, that.nextPrivateKeySecretName)) return false;
  
    if (!java.util.Objects.equals(notAfter, that.notAfter)) return false;
  
    if (!java.util.Objects.equals(notBefore, that.notBefore)) return false;
  
    if (!java.util.Objects.equals(renewalTime, that.renewalTime)) return false;
  
    if (!java.util.Objects.equals(revision, that.revision)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  lastFailureTime,  nextPrivateKeySecretName,  notAfter,  notBefore,  renewalTime,  revision,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (lastFailureTime != null) { sb.append("lastFailureTime:"); sb.append(lastFailureTime + ","); }
    if (nextPrivateKeySecretName != null) { sb.append("nextPrivateKeySecretName:"); sb.append(nextPrivateKeySecretName + ","); }
    if (notAfter != null) { sb.append("notAfter:"); sb.append(notAfter + ","); }
    if (notBefore != null) { sb.append("notBefore:"); sb.append(notBefore + ","); }
    if (renewalTime != null) { sb.append("renewalTime:"); sb.append(renewalTime + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends CertificateConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,CertificateCondition item) {
      this.index = index;
      this.builder = new CertificateConditionBuilder(this, item);
    }
    CertificateConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) CertificateStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }

}