package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertificateSpecBuilder extends CertificateSpecFluent<CertificateSpecBuilder> implements VisitableBuilder<CertificateSpec,CertificateSpecBuilder>{
  public CertificateSpecBuilder() {
    this(new CertificateSpec());
  }
  
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent) {
    this(fluent, new CertificateSpec());
  }
  
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,CertificateSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertificateSpecBuilder(CertificateSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertificateSpecFluent<?> fluent;
  
  public CertificateSpec build() {
    CertificateSpec buildable = new CertificateSpec(fluent.getCommonName(),fluent.getDnsNames(),fluent.getDuration(),fluent.getEmailSANs(),fluent.getEncodeUsagesInRequest(),fluent.getIpAddresses(),fluent.getIsCA(),fluent.buildIssuerRef(),fluent.getKeyAlgorithm(),fluent.getKeyEncoding(),fluent.getKeySize(),fluent.buildKeystores(),fluent.getOrganization(),fluent.buildPrivateKey(),fluent.getRenewBefore(),fluent.getRevisionHistoryLimit(),fluent.getSecretName(),fluent.buildSecretTemplate(),fluent.buildSubject(),fluent.getUriSANs(),fluent.getUsages());
    return buildable;
  }
  

}