package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertificateRequestSpecFluent<A extends CertificateRequestSpecFluent<A>> extends BaseFluent<A>{
  public CertificateRequestSpecFluent() {
  }
  
  public CertificateRequestSpecFluent(CertificateRequestSpec instance) {
    this.copyInstance(instance);
  }
  private String csr;
  private Duration duration;
  private Map<String,List<String>> extra;
  private List<String> groups = new ArrayList<String>();
  private Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private String uid;
  private List<String> usages = new ArrayList<String>();
  private String username;
  
  protected void copyInstance(CertificateRequestSpec instance) {
    instance = (instance != null ? instance : new CertificateRequestSpec());
  
    if (instance != null) {
        this.withCsr(instance.getCsr());
        this.withDuration(instance.getDuration());
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withIsCA(instance.getIsCA());
        this.withIssuerRef(instance.getIssuerRef());
        this.withUid(instance.getUid());
        this.withUsages(instance.getUsages());
        this.withUsername(instance.getUsername());
        this.withCsr(instance.getCsr());
        this.withDuration(instance.getDuration());
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withIsCA(instance.getIsCA());
        this.withIssuerRef(instance.getIssuerRef());
        this.withUid(instance.getUid());
        this.withUsages(instance.getUsages());
        this.withUsername(instance.getUsername());
      }
  }
  
  public String getCsr() {
    return this.csr;
  }
  
  public A withCsr(String csr) {
    this.csr=csr; return (A) this;
  }
  
  public boolean hasCsr() {
    return this.csr != null;
  }
  
  public Duration getDuration() {
    return this.duration;
  }
  
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public A addToExtra(String key,List<String> value) {
    if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap(); }
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
  }
  
  public A addToExtra(Map<String,List<String>> map) {
    if(this.extra == null && map != null) { this.extra = new LinkedHashMap(); }
    if(map != null) { this.extra.putAll(map);} return (A)this;
  }
  
  public A removeFromExtra(String key) {
    if(this.extra == null) { return (A) this; }
    if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
  }
  
  public A removeFromExtra(Map<String,List<String>> map) {
    if(this.extra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<String>> getExtra() {
    return this.extra;
  }
  
  public <K,V>A withExtra(Map<String,List<String>> extra) {
    if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap(extra);} return (A) this;
  }
  
  public boolean hasExtra() {
    return this.extra != null;
  }
  
  public A addToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  
  public A setToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  
  public A removeFromGroups(java.lang.String... items) {
    if (this.groups == null) return (A)this;
    for (String item : items) { this.groups.remove(item);} return (A)this;
  }
  
  public A removeAllFromGroups(Collection<String> items) {
    if (this.groups == null) return (A)this;
    for (String item : items) { this.groups.remove(item);} return (A)this;
  }
  
  public List<String> getGroups() {
    return this.groups;
  }
  
  public String getGroup(int index) {
    return this.groups.get(index);
  }
  
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear(); _visitables.remove("groups"); }
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  
  public boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  
  public Boolean getIsCA() {
    return this.isCA;
  }
  
  public A withIsCA(Boolean isCA) {
    this.isCA=isCA; return (A) this;
  }
  
  public boolean hasIsCA() {
    return this.isCA != null;
  }
  
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  
  public boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  
  public IssuerRefNested<A> withNewIssuerRef() {
    return new IssuerRefNested(null);
  }
  
  public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new IssuerRefNested(item);
  }
  
  public IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(null));
  }
  
  public IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(item));
  }
  
  public String getUid() {
    return this.uid;
  }
  
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  
  public boolean hasUid() {
    return this.uid != null;
  }
  
  public A addToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  
  public A setToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  
  public A removeFromUsages(java.lang.String... items) {
    if (this.usages == null) return (A)this;
    for (String item : items) { this.usages.remove(item);} return (A)this;
  }
  
  public A removeAllFromUsages(Collection<String> items) {
    if (this.usages == null) return (A)this;
    for (String item : items) { this.usages.remove(item);} return (A)this;
  }
  
  public List<String> getUsages() {
    return this.usages;
  }
  
  public String getUsage(int index) {
    return this.usages.get(index);
  }
  
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  
  public String getMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withUsages(List<String> usages) {
    if (usages != null) {this.usages = new ArrayList(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear(); _visitables.remove("usages"); }
    if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  
  public boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateRequestSpecFluent that = (CertificateRequestSpecFluent) o;
    if (!java.util.Objects.equals(csr, that.csr)) return false;
  
    if (!java.util.Objects.equals(duration, that.duration)) return false;
  
    if (!java.util.Objects.equals(extra, that.extra)) return false;
  
    if (!java.util.Objects.equals(groups, that.groups)) return false;
  
    if (!java.util.Objects.equals(isCA, that.isCA)) return false;
  
    if (!java.util.Objects.equals(issuerRef, that.issuerRef)) return false;
  
    if (!java.util.Objects.equals(uid, that.uid)) return false;
  
    if (!java.util.Objects.equals(usages, that.usages)) return false;
  
    if (!java.util.Objects.equals(username, that.username)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(csr,  duration,  extra,  groups,  isCA,  issuerRef,  uid,  usages,  username,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (csr != null) { sb.append("csr:"); sb.append(csr + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages + ","); }
    if (username != null) { sb.append("username:"); sb.append(username); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withIsCA() {
    return withIsCA(true);
  }
  public class IssuerRefNested<N> extends ObjectReferenceFluent<IssuerRefNested<N>> implements Nested<N>{
    IssuerRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) CertificateRequestSpecFluent.this.withIssuerRef(builder.build());
    }
    
    public N endIssuerRef() {
      return and();
    }
    
  
  }

}