package io.fabric8.certmanager.api.model.meta.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ObjectReferenceBuilder extends ObjectReferenceFluent<ObjectReferenceBuilder> implements VisitableBuilder<ObjectReference,ObjectReferenceBuilder>{
  public ObjectReferenceBuilder() {
    this(new ObjectReference());
  }
  
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
    this(fluent, new ObjectReference());
  }
  
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,ObjectReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ObjectReferenceBuilder(ObjectReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ObjectReferenceFluent<?> fluent;
  
  public ObjectReference build() {
    ObjectReference buildable = new ObjectReference(fluent.getGroup(),fluent.getKind(),fluent.getName());
    return buildable;
  }
  

}