package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OrderListBuilder extends OrderListFluent<OrderListBuilder> implements VisitableBuilder<OrderList,OrderListBuilder>{
  public OrderListBuilder() {
    this(new OrderList());
  }
  
  public OrderListBuilder(OrderListFluent<?> fluent) {
    this(fluent, new OrderList());
  }
  
  public OrderListBuilder(OrderListFluent<?> fluent,OrderList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OrderListBuilder(OrderList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OrderListFluent<?> fluent;
  
  public OrderList build() {
    OrderList buildable = new OrderList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}