package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ACMEIssuerStatusBuilder extends ACMEIssuerStatusFluent<ACMEIssuerStatusBuilder> implements VisitableBuilder<ACMEIssuerStatus,ACMEIssuerStatusBuilder>{
  public ACMEIssuerStatusBuilder() {
    this(new ACMEIssuerStatus());
  }
  
  public ACMEIssuerStatusBuilder(ACMEIssuerStatusFluent<?> fluent) {
    this(fluent, new ACMEIssuerStatus());
  }
  
  public ACMEIssuerStatusBuilder(ACMEIssuerStatusFluent<?> fluent,ACMEIssuerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ACMEIssuerStatusBuilder(ACMEIssuerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ACMEIssuerStatusFluent<?> fluent;
  
  public ACMEIssuerStatus build() {
    ACMEIssuerStatus buildable = new ACMEIssuerStatus(fluent.getLastRegisteredEmail(),fluent.getUri());
    return buildable;
  }
  

}