package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEExternalAccountBindingFluent<A extends ACMEExternalAccountBindingFluent<A>> extends BaseFluent<A>{
  public ACMEExternalAccountBindingFluent() {
  }
  
  public ACMEExternalAccountBindingFluent(ACMEExternalAccountBinding instance) {
    this.copyInstance(instance);
  }
  private String keyAlgorithm;
  private String keyID;
  private SecretKeySelectorBuilder keySecretRef;
  
  protected void copyInstance(ACMEExternalAccountBinding instance) {
    instance = (instance != null ? instance : new ACMEExternalAccountBinding());
  
    if (instance != null) {
        this.withKeyAlgorithm(instance.getKeyAlgorithm());
        this.withKeyID(instance.getKeyID());
        this.withKeySecretRef(instance.getKeySecretRef());
        this.withKeyAlgorithm(instance.getKeyAlgorithm());
        this.withKeyID(instance.getKeyID());
        this.withKeySecretRef(instance.getKeySecretRef());
      }
  }
  
  public String getKeyAlgorithm() {
    return this.keyAlgorithm;
  }
  
  public A withKeyAlgorithm(String keyAlgorithm) {
    this.keyAlgorithm=keyAlgorithm; return (A) this;
  }
  
  public boolean hasKeyAlgorithm() {
    return this.keyAlgorithm != null;
  }
  
  public String getKeyID() {
    return this.keyID;
  }
  
  public A withKeyID(String keyID) {
    this.keyID=keyID; return (A) this;
  }
  
  public boolean hasKeyID() {
    return this.keyID != null;
  }
  
  public SecretKeySelector buildKeySecretRef() {
    return this.keySecretRef!=null ?this.keySecretRef.build():null;
  }
  
  public A withKeySecretRef(SecretKeySelector keySecretRef) {
    _visitables.get("keySecretRef").remove(this.keySecretRef);
    if (keySecretRef!=null){ this.keySecretRef= new SecretKeySelectorBuilder(keySecretRef); _visitables.get("keySecretRef").add(this.keySecretRef);} else { this.keySecretRef = null; _visitables.get("keySecretRef").remove(this.keySecretRef); } return (A) this;
  }
  
  public boolean hasKeySecretRef() {
    return this.keySecretRef != null;
  }
  
  public A withNewKeySecretRef(String key,String name) {
    return (A)withKeySecretRef(new SecretKeySelector(key, name));
  }
  
  public KeySecretRefNested<A> withNewKeySecretRef() {
    return new KeySecretRefNested(null);
  }
  
  public KeySecretRefNested<A> withNewKeySecretRefLike(SecretKeySelector item) {
    return new KeySecretRefNested(item);
  }
  
  public KeySecretRefNested<A> editKeySecretRef() {
    return withNewKeySecretRefLike(java.util.Optional.ofNullable(buildKeySecretRef()).orElse(null));
  }
  
  public KeySecretRefNested<A> editOrNewKeySecretRef() {
    return withNewKeySecretRefLike(java.util.Optional.ofNullable(buildKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public KeySecretRefNested<A> editOrNewKeySecretRefLike(SecretKeySelector item) {
    return withNewKeySecretRefLike(java.util.Optional.ofNullable(buildKeySecretRef()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEExternalAccountBindingFluent that = (ACMEExternalAccountBindingFluent) o;
    if (!java.util.Objects.equals(keyAlgorithm, that.keyAlgorithm)) return false;
  
    if (!java.util.Objects.equals(keyID, that.keyID)) return false;
  
    if (!java.util.Objects.equals(keySecretRef, that.keySecretRef)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(keyAlgorithm,  keyID,  keySecretRef,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (keyAlgorithm != null) { sb.append("keyAlgorithm:"); sb.append(keyAlgorithm + ","); }
    if (keyID != null) { sb.append("keyID:"); sb.append(keyID + ","); }
    if (keySecretRef != null) { sb.append("keySecretRef:"); sb.append(keySecretRef); }
    sb.append("}");
    return sb.toString();
  }
  public class KeySecretRefNested<N> extends SecretKeySelectorFluent<KeySecretRefNested<N>> implements Nested<N>{
    KeySecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEExternalAccountBindingFluent.this.withKeySecretRef(builder.build());
    }
    
    public N endKeySecretRef() {
      return and();
    }
    
  
  }

}