package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ACMEChallengeSolverBuilder extends ACMEChallengeSolverFluent<ACMEChallengeSolverBuilder> implements VisitableBuilder<ACMEChallengeSolver,ACMEChallengeSolverBuilder>{
  public ACMEChallengeSolverBuilder() {
    this(new ACMEChallengeSolver());
  }
  
  public ACMEChallengeSolverBuilder(ACMEChallengeSolverFluent<?> fluent) {
    this(fluent, new ACMEChallengeSolver());
  }
  
  public ACMEChallengeSolverBuilder(ACMEChallengeSolverFluent<?> fluent,ACMEChallengeSolver instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ACMEChallengeSolverBuilder(ACMEChallengeSolver instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ACMEChallengeSolverFluent<?> fluent;
  
  public ACMEChallengeSolver build() {
    ACMEChallengeSolver buildable = new ACMEChallengeSolver(fluent.buildDns01(),fluent.buildHttp01(),fluent.buildSelector());
    return buildable;
  }
  

}