/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class VaultAppRoleFluent<A extends VaultAppRoleFluent<A>>
extends BaseFluent<A> {
    private String path;
    private String roleId;
    private SecretKeySelectorBuilder secretRef;

    public VaultAppRoleFluent() {
    }

    public VaultAppRoleFluent(VaultAppRole instance) {
        VaultAppRole vaultAppRole = instance = instance != null ? instance : new VaultAppRole();
        if (instance != null) {
            this.withPath(instance.getPath());
            this.withRoleId(instance.getRoleId());
            this.withSecretRef(instance.getSecretRef());
            this.withPath(instance.getPath());
            this.withRoleId(instance.getRoleId());
            this.withSecretRef(instance.getSecretRef());
        }
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public A withRoleId(String roleId) {
        this.roleId = roleId;
        return (A)((Object)this);
    }

    public boolean hasRoleId() {
        return this.roleId != null;
    }

    public SecretKeySelector buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretKeySelector secretRef) {
        this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretKeySelectorBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String key, String name) {
        return this.withSecretRef(new SecretKeySelector(key, name));
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretKeySelector item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretKeySelector item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VaultAppRoleFluent that = (VaultAppRoleFluent)((Object)o);
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.roleId, that.roleId)) {
            return false;
        }
        return Objects.equals((Object)this.secretRef, (Object)that.secretRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.roleId, this.secretRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.roleId != null) {
            sb.append("roleId:");
            sb.append(this.roleId + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append((Object)this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretRefNested<N>
    extends SecretKeySelectorFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        SecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)VaultAppRoleFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

