/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateKeystores;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateKeystoresBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateKeystoresFluent;
import io.fabric8.certmanager.api.model.v1alpha2.CertificatePrivateKey;
import io.fabric8.certmanager.api.model.v1alpha2.CertificatePrivateKeyBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.CertificatePrivateKeyFluent;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateSecretTemplate;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateSecretTemplateBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateSecretTemplateFluent;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateSpec;
import io.fabric8.certmanager.api.model.v1alpha2.X509Subject;
import io.fabric8.certmanager.api.model.v1alpha2.X509SubjectBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.X509SubjectFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CertificateSpecFluent<A extends CertificateSpecFluent<A>>
extends BaseFluent<A> {
    private String commonName;
    private List<String> dnsNames = new ArrayList<String>();
    private Duration duration;
    private List<String> emailSANs = new ArrayList<String>();
    private Boolean encodeUsagesInRequest;
    private List<String> ipAddresses = new ArrayList<String>();
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private String keyAlgorithm;
    private String keyEncoding;
    private Integer keySize;
    private CertificateKeystoresBuilder keystores;
    private List<String> organization = new ArrayList<String>();
    private CertificatePrivateKeyBuilder privateKey;
    private Duration renewBefore;
    private Integer revisionHistoryLimit;
    private String secretName;
    private CertificateSecretTemplateBuilder secretTemplate;
    private X509SubjectBuilder subject;
    private List<String> uriSANs = new ArrayList<String>();
    private List<String> usages = new ArrayList<String>();

    public CertificateSpecFluent() {
    }

    public CertificateSpecFluent(CertificateSpec instance) {
        CertificateSpec certificateSpec = instance = instance != null ? instance : new CertificateSpec();
        if (instance != null) {
            this.withCommonName(instance.getCommonName());
            this.withDnsNames(instance.getDnsNames());
            this.withDuration(instance.getDuration());
            this.withEmailSANs(instance.getEmailSANs());
            this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
            this.withIpAddresses(instance.getIpAddresses());
            this.withIsCA(instance.getIsCA());
            this.withIssuerRef(instance.getIssuerRef());
            this.withKeyAlgorithm(instance.getKeyAlgorithm());
            this.withKeyEncoding(instance.getKeyEncoding());
            this.withKeySize(instance.getKeySize());
            this.withKeystores(instance.getKeystores());
            this.withOrganization(instance.getOrganization());
            this.withPrivateKey(instance.getPrivateKey());
            this.withRenewBefore(instance.getRenewBefore());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSecretName(instance.getSecretName());
            this.withSecretTemplate(instance.getSecretTemplate());
            this.withSubject(instance.getSubject());
            this.withUriSANs(instance.getUriSANs());
            this.withUsages(instance.getUsages());
            this.withCommonName(instance.getCommonName());
            this.withDnsNames(instance.getDnsNames());
            this.withDuration(instance.getDuration());
            this.withEmailSANs(instance.getEmailSANs());
            this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
            this.withIpAddresses(instance.getIpAddresses());
            this.withIsCA(instance.getIsCA());
            this.withIssuerRef(instance.getIssuerRef());
            this.withKeyAlgorithm(instance.getKeyAlgorithm());
            this.withKeyEncoding(instance.getKeyEncoding());
            this.withKeySize(instance.getKeySize());
            this.withKeystores(instance.getKeystores());
            this.withOrganization(instance.getOrganization());
            this.withPrivateKey(instance.getPrivateKey());
            this.withRenewBefore(instance.getRenewBefore());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSecretName(instance.getSecretName());
            this.withSecretTemplate(instance.getSecretTemplate());
            this.withSubject(instance.getSubject());
            this.withUriSANs(instance.getUriSANs());
            this.withUsages(instance.getUsages());
        }
    }

    public String getCommonName() {
        return this.commonName;
    }

    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)((Object)this);
    }

    public boolean hasCommonName() {
        return this.commonName != null;
    }

    public A addToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDnsNames(String ... items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public String getDnsName(int index) {
        return this.dnsNames.get(index);
    }

    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)((Object)this);
    }

    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
            this._visitables.remove((Object)"dnsNames");
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public A addToEmailSANs(int index, String item) {
        if (this.emailSANs == null) {
            this.emailSANs = new ArrayList<String>();
        }
        this.emailSANs.add(index, item);
        return (A)((Object)this);
    }

    public A setToEmailSANs(int index, String item) {
        if (this.emailSANs == null) {
            this.emailSANs = new ArrayList<String>();
        }
        this.emailSANs.set(index, item);
        return (A)((Object)this);
    }

    public A addToEmailSANs(String ... items) {
        if (this.emailSANs == null) {
            this.emailSANs = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailSANs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEmailSANs(Collection<String> items) {
        if (this.emailSANs == null) {
            this.emailSANs = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailSANs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEmailSANs(String ... items) {
        if (this.emailSANs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailSANs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEmailSANs(Collection<String> items) {
        if (this.emailSANs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailSANs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEmailSANs() {
        return this.emailSANs;
    }

    public String getEmailSAN(int index) {
        return this.emailSANs.get(index);
    }

    public String getFirstEmailSAN() {
        return this.emailSANs.get(0);
    }

    public String getLastEmailSAN() {
        return this.emailSANs.get(this.emailSANs.size() - 1);
    }

    public String getMatchingEmailSAN(Predicate<String> predicate) {
        for (String item : this.emailSANs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEmailSAN(Predicate<String> predicate) {
        for (String item : this.emailSANs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEmailSANs(List<String> emailSANs) {
        if (emailSANs != null) {
            this.emailSANs = new ArrayList<String>();
            for (String item : emailSANs) {
                this.addToEmailSANs(item);
            }
        } else {
            this.emailSANs = null;
        }
        return (A)((Object)this);
    }

    public A withEmailSANs(String ... emailSANs) {
        if (this.emailSANs != null) {
            this.emailSANs.clear();
            this._visitables.remove((Object)"emailSANs");
        }
        if (emailSANs != null) {
            for (String item : emailSANs) {
                this.addToEmailSANs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEmailSANs() {
        return this.emailSANs != null && !this.emailSANs.isEmpty();
    }

    public Boolean getEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest;
    }

    public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
        this.encodeUsagesInRequest = encodeUsagesInRequest;
        return (A)((Object)this);
    }

    public boolean hasEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest != null;
    }

    public A addToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public String getIpAddress(int index) {
        return this.ipAddresses.get(index);
    }

    public String getFirstIpAddress() {
        return this.ipAddresses.get(0);
    }

    public String getLastIpAddress() {
        return this.ipAddresses.get(this.ipAddresses.size() - 1);
    }

    public String getMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpAddresses(List<String> ipAddresses) {
        if (ipAddresses != null) {
            this.ipAddresses = new ArrayList<String>();
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        } else {
            this.ipAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
            this._visitables.remove((Object)"ipAddresses");
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    public Boolean getIsCA() {
        return this.isCA;
    }

    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)((Object)this);
    }

    public boolean hasIsCA() {
        return this.isCA != null;
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public A withKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return (A)((Object)this);
    }

    public boolean hasKeyAlgorithm() {
        return this.keyAlgorithm != null;
    }

    public String getKeyEncoding() {
        return this.keyEncoding;
    }

    public A withKeyEncoding(String keyEncoding) {
        this.keyEncoding = keyEncoding;
        return (A)((Object)this);
    }

    public boolean hasKeyEncoding() {
        return this.keyEncoding != null;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public A withKeySize(Integer keySize) {
        this.keySize = keySize;
        return (A)((Object)this);
    }

    public boolean hasKeySize() {
        return this.keySize != null;
    }

    public CertificateKeystores buildKeystores() {
        return this.keystores != null ? this.keystores.build() : null;
    }

    public A withKeystores(CertificateKeystores keystores) {
        this._visitables.get((Object)"keystores").remove((Object)this.keystores);
        if (keystores != null) {
            this.keystores = new CertificateKeystoresBuilder(keystores);
            this._visitables.get((Object)"keystores").add(this.keystores);
        } else {
            this.keystores = null;
            this._visitables.get((Object)"keystores").remove((Object)this.keystores);
        }
        return (A)((Object)this);
    }

    public boolean hasKeystores() {
        return this.keystores != null;
    }

    public KeystoresNested<A> withNewKeystores() {
        return new KeystoresNested(null);
    }

    public KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
        return new KeystoresNested(item);
    }

    public KeystoresNested<A> editKeystores() {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(null));
    }

    public KeystoresNested<A> editOrNewKeystores() {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(new CertificateKeystoresBuilder().build()));
    }

    public KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(item));
    }

    public A addToOrganization(int index, String item) {
        if (this.organization == null) {
            this.organization = new ArrayList<String>();
        }
        this.organization.add(index, item);
        return (A)((Object)this);
    }

    public A setToOrganization(int index, String item) {
        if (this.organization == null) {
            this.organization = new ArrayList<String>();
        }
        this.organization.set(index, item);
        return (A)((Object)this);
    }

    public A addToOrganization(String ... items) {
        if (this.organization == null) {
            this.organization = new ArrayList<String>();
        }
        for (String item : items) {
            this.organization.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOrganization(Collection<String> items) {
        if (this.organization == null) {
            this.organization = new ArrayList<String>();
        }
        for (String item : items) {
            this.organization.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOrganization(String ... items) {
        if (this.organization == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organization.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOrganization(Collection<String> items) {
        if (this.organization == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organization.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOrganization() {
        return this.organization;
    }

    public String getOrganization(int index) {
        return this.organization.get(index);
    }

    public String getFirstOrganization() {
        return this.organization.get(0);
    }

    public String getLastOrganization() {
        return this.organization.get(this.organization.size() - 1);
    }

    public String getMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organization) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organization) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOrganization(List<String> organization) {
        if (organization != null) {
            this.organization = new ArrayList<String>();
            for (String item : organization) {
                this.addToOrganization(item);
            }
        } else {
            this.organization = null;
        }
        return (A)((Object)this);
    }

    public A withOrganization(String ... organization) {
        if (this.organization != null) {
            this.organization.clear();
            this._visitables.remove((Object)"organization");
        }
        if (organization != null) {
            for (String item : organization) {
                this.addToOrganization(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public CertificatePrivateKey buildPrivateKey() {
        return this.privateKey != null ? this.privateKey.build() : null;
    }

    public A withPrivateKey(CertificatePrivateKey privateKey) {
        this._visitables.get((Object)"privateKey").remove((Object)this.privateKey);
        if (privateKey != null) {
            this.privateKey = new CertificatePrivateKeyBuilder(privateKey);
            this._visitables.get((Object)"privateKey").add(this.privateKey);
        } else {
            this.privateKey = null;
            this._visitables.get((Object)"privateKey").remove((Object)this.privateKey);
        }
        return (A)((Object)this);
    }

    public boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    public A withNewPrivateKey(String rotationPolicy) {
        return this.withPrivateKey(new CertificatePrivateKey(rotationPolicy));
    }

    public PrivateKeyNested<A> withNewPrivateKey() {
        return new PrivateKeyNested(null);
    }

    public PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
        return new PrivateKeyNested(item);
    }

    public PrivateKeyNested<A> editPrivateKey() {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(null));
    }

    public PrivateKeyNested<A> editOrNewPrivateKey() {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(new CertificatePrivateKeyBuilder().build()));
    }

    public PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(item));
    }

    public Duration getRenewBefore() {
        return this.renewBefore;
    }

    public A withRenewBefore(Duration renewBefore) {
        this.renewBefore = renewBefore;
        return (A)((Object)this);
    }

    public boolean hasRenewBefore() {
        return this.renewBefore != null;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)((Object)this);
    }

    public boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public CertificateSecretTemplate buildSecretTemplate() {
        return this.secretTemplate != null ? this.secretTemplate.build() : null;
    }

    public A withSecretTemplate(CertificateSecretTemplate secretTemplate) {
        this._visitables.get((Object)"secretTemplate").remove((Object)this.secretTemplate);
        if (secretTemplate != null) {
            this.secretTemplate = new CertificateSecretTemplateBuilder(secretTemplate);
            this._visitables.get((Object)"secretTemplate").add(this.secretTemplate);
        } else {
            this.secretTemplate = null;
            this._visitables.get((Object)"secretTemplate").remove((Object)this.secretTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretTemplate() {
        return this.secretTemplate != null;
    }

    public SecretTemplateNested<A> withNewSecretTemplate() {
        return new SecretTemplateNested(null);
    }

    public SecretTemplateNested<A> withNewSecretTemplateLike(CertificateSecretTemplate item) {
        return new SecretTemplateNested(item);
    }

    public SecretTemplateNested<A> editSecretTemplate() {
        return this.withNewSecretTemplateLike(Optional.ofNullable(this.buildSecretTemplate()).orElse(null));
    }

    public SecretTemplateNested<A> editOrNewSecretTemplate() {
        return this.withNewSecretTemplateLike(Optional.ofNullable(this.buildSecretTemplate()).orElse(new CertificateSecretTemplateBuilder().build()));
    }

    public SecretTemplateNested<A> editOrNewSecretTemplateLike(CertificateSecretTemplate item) {
        return this.withNewSecretTemplateLike(Optional.ofNullable(this.buildSecretTemplate()).orElse(item));
    }

    public X509Subject buildSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    public A withSubject(X509Subject subject) {
        this._visitables.get((Object)"subject").remove((Object)this.subject);
        if (subject != null) {
            this.subject = new X509SubjectBuilder(subject);
            this._visitables.get((Object)"subject").add(this.subject);
        } else {
            this.subject = null;
            this._visitables.get((Object)"subject").remove((Object)this.subject);
        }
        return (A)((Object)this);
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public SubjectNested<A> withNewSubject() {
        return new SubjectNested(null);
    }

    public SubjectNested<A> withNewSubjectLike(X509Subject item) {
        return new SubjectNested(item);
    }

    public SubjectNested<A> editSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(null));
    }

    public SubjectNested<A> editOrNewSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(new X509SubjectBuilder().build()));
    }

    public SubjectNested<A> editOrNewSubjectLike(X509Subject item) {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(item));
    }

    public A addToUriSANs(int index, String item) {
        if (this.uriSANs == null) {
            this.uriSANs = new ArrayList<String>();
        }
        this.uriSANs.add(index, item);
        return (A)((Object)this);
    }

    public A setToUriSANs(int index, String item) {
        if (this.uriSANs == null) {
            this.uriSANs = new ArrayList<String>();
        }
        this.uriSANs.set(index, item);
        return (A)((Object)this);
    }

    public A addToUriSANs(String ... items) {
        if (this.uriSANs == null) {
            this.uriSANs = new ArrayList<String>();
        }
        for (String item : items) {
            this.uriSANs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUriSANs(Collection<String> items) {
        if (this.uriSANs == null) {
            this.uriSANs = new ArrayList<String>();
        }
        for (String item : items) {
            this.uriSANs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUriSANs(String ... items) {
        if (this.uriSANs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uriSANs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUriSANs(Collection<String> items) {
        if (this.uriSANs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uriSANs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUriSANs() {
        return this.uriSANs;
    }

    public String getUriSAN(int index) {
        return this.uriSANs.get(index);
    }

    public String getFirstUriSAN() {
        return this.uriSANs.get(0);
    }

    public String getLastUriSAN() {
        return this.uriSANs.get(this.uriSANs.size() - 1);
    }

    public String getMatchingUriSAN(Predicate<String> predicate) {
        for (String item : this.uriSANs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUriSAN(Predicate<String> predicate) {
        for (String item : this.uriSANs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUriSANs(List<String> uriSANs) {
        if (uriSANs != null) {
            this.uriSANs = new ArrayList<String>();
            for (String item : uriSANs) {
                this.addToUriSANs(item);
            }
        } else {
            this.uriSANs = null;
        }
        return (A)((Object)this);
    }

    public A withUriSANs(String ... uriSANs) {
        if (this.uriSANs != null) {
            this.uriSANs.clear();
            this._visitables.remove((Object)"uriSANs");
        }
        if (uriSANs != null) {
            for (String item : uriSANs) {
                this.addToUriSANs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUriSANs() {
        return this.uriSANs != null && !this.uriSANs.isEmpty();
    }

    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)((Object)this);
    }

    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)((Object)this);
    }

    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUsages(String ... items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUsages(Collection<String> items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public String getUsage(int index) {
        return this.usages.get(index);
    }

    public String getFirstUsage() {
        return this.usages.get(0);
    }

    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)((Object)this);
    }

    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove((Object)"usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateSpecFluent that = (CertificateSpecFluent)((Object)o);
        if (!Objects.equals(this.commonName, that.commonName)) {
            return false;
        }
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.emailSANs, that.emailSANs)) {
            return false;
        }
        if (!Objects.equals(this.encodeUsagesInRequest, that.encodeUsagesInRequest)) {
            return false;
        }
        if (!Objects.equals(this.ipAddresses, that.ipAddresses)) {
            return false;
        }
        if (!Objects.equals(this.isCA, that.isCA)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.keyAlgorithm, that.keyAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.keyEncoding, that.keyEncoding)) {
            return false;
        }
        if (!Objects.equals(this.keySize, that.keySize)) {
            return false;
        }
        if (!Objects.equals((Object)this.keystores, (Object)that.keystores)) {
            return false;
        }
        if (!Objects.equals(this.organization, that.organization)) {
            return false;
        }
        if (!Objects.equals((Object)this.privateKey, (Object)that.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.renewBefore, that.renewBefore)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretTemplate, (Object)that.secretTemplate)) {
            return false;
        }
        if (!Objects.equals((Object)this.subject, (Object)that.subject)) {
            return false;
        }
        if (!Objects.equals(this.uriSANs, that.uriSANs)) {
            return false;
        }
        return Objects.equals(this.usages, that.usages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commonName, this.dnsNames, this.duration, this.emailSANs, this.encodeUsagesInRequest, this.ipAddresses, this.isCA, this.issuerRef, this.keyAlgorithm, this.keyEncoding, this.keySize, this.keystores, this.organization, this.privateKey, this.renewBefore, this.revisionHistoryLimit, this.secretName, this.secretTemplate, this.subject, this.uriSANs, this.usages, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commonName != null) {
            sb.append("commonName:");
            sb.append(this.commonName + ",");
        }
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.emailSANs != null && !this.emailSANs.isEmpty()) {
            sb.append("emailSANs:");
            sb.append(this.emailSANs + ",");
        }
        if (this.encodeUsagesInRequest != null) {
            sb.append("encodeUsagesInRequest:");
            sb.append(this.encodeUsagesInRequest + ",");
        }
        if (this.ipAddresses != null && !this.ipAddresses.isEmpty()) {
            sb.append("ipAddresses:");
            sb.append(this.ipAddresses + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)((Object)this.issuerRef) + ",");
        }
        if (this.keyAlgorithm != null) {
            sb.append("keyAlgorithm:");
            sb.append(this.keyAlgorithm + ",");
        }
        if (this.keyEncoding != null) {
            sb.append("keyEncoding:");
            sb.append(this.keyEncoding + ",");
        }
        if (this.keySize != null) {
            sb.append("keySize:");
            sb.append(this.keySize + ",");
        }
        if (this.keystores != null) {
            sb.append("keystores:");
            sb.append((Object)((Object)this.keystores) + ",");
        }
        if (this.organization != null && !this.organization.isEmpty()) {
            sb.append("organization:");
            sb.append(this.organization + ",");
        }
        if (this.privateKey != null) {
            sb.append("privateKey:");
            sb.append((Object)((Object)this.privateKey) + ",");
        }
        if (this.renewBefore != null) {
            sb.append("renewBefore:");
            sb.append(this.renewBefore + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.secretTemplate != null) {
            sb.append("secretTemplate:");
            sb.append((Object)((Object)this.secretTemplate) + ",");
        }
        if (this.subject != null) {
            sb.append("subject:");
            sb.append((Object)((Object)this.subject) + ",");
        }
        if (this.uriSANs != null && !this.uriSANs.isEmpty()) {
            sb.append("uriSANs:");
            sb.append(this.uriSANs + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEncodeUsagesInRequest() {
        return this.withEncodeUsagesInRequest(true);
    }

    public A withIsCA() {
        return this.withIsCA(true);
    }

    public class SubjectNested<N>
    extends X509SubjectFluent<SubjectNested<N>>
    implements Nested<N> {
        X509SubjectBuilder builder;

        SubjectNested(X509Subject item) {
            this.builder = new X509SubjectBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withSubject(this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class SecretTemplateNested<N>
    extends CertificateSecretTemplateFluent<SecretTemplateNested<N>>
    implements Nested<N> {
        CertificateSecretTemplateBuilder builder;

        SecretTemplateNested(CertificateSecretTemplate item) {
            this.builder = new CertificateSecretTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withSecretTemplate(this.builder.build());
        }

        public N endSecretTemplate() {
            return this.and();
        }
    }

    public class PrivateKeyNested<N>
    extends CertificatePrivateKeyFluent<PrivateKeyNested<N>>
    implements Nested<N> {
        CertificatePrivateKeyBuilder builder;

        PrivateKeyNested(CertificatePrivateKey item) {
            this.builder = new CertificatePrivateKeyBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withPrivateKey(this.builder.build());
        }

        public N endPrivateKey() {
            return this.and();
        }
    }

    public class KeystoresNested<N>
    extends CertificateKeystoresFluent<KeystoresNested<N>>
    implements Nested<N> {
        CertificateKeystoresBuilder builder;

        KeystoresNested(CertificateKeystores item) {
            this.builder = new CertificateKeystoresBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withKeystores(this.builder.build());
        }

        public N endKeystores() {
            return this.and();
        }
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

