/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.CertificateKeystores;
import io.fabric8.certmanager.api.model.v1alpha2.JKSKeystore;
import io.fabric8.certmanager.api.model.v1alpha2.JKSKeystoreBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.JKSKeystoreFluent;
import io.fabric8.certmanager.api.model.v1alpha2.PKCS12Keystore;
import io.fabric8.certmanager.api.model.v1alpha2.PKCS12KeystoreBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.PKCS12KeystoreFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class CertificateKeystoresFluent<A extends CertificateKeystoresFluent<A>>
extends BaseFluent<A> {
    private JKSKeystoreBuilder jks;
    private PKCS12KeystoreBuilder pkcs12;

    public CertificateKeystoresFluent() {
    }

    public CertificateKeystoresFluent(CertificateKeystores instance) {
        CertificateKeystores certificateKeystores = instance = instance != null ? instance : new CertificateKeystores();
        if (instance != null) {
            this.withJks(instance.getJks());
            this.withPkcs12(instance.getPkcs12());
            this.withJks(instance.getJks());
            this.withPkcs12(instance.getPkcs12());
        }
    }

    public JKSKeystore buildJks() {
        return this.jks != null ? this.jks.build() : null;
    }

    public A withJks(JKSKeystore jks) {
        this._visitables.get((Object)"jks").remove((Object)this.jks);
        if (jks != null) {
            this.jks = new JKSKeystoreBuilder(jks);
            this._visitables.get((Object)"jks").add(this.jks);
        } else {
            this.jks = null;
            this._visitables.get((Object)"jks").remove((Object)this.jks);
        }
        return (A)((Object)this);
    }

    public boolean hasJks() {
        return this.jks != null;
    }

    public JksNested<A> withNewJks() {
        return new JksNested(null);
    }

    public JksNested<A> withNewJksLike(JKSKeystore item) {
        return new JksNested(item);
    }

    public JksNested<A> editJks() {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(null));
    }

    public JksNested<A> editOrNewJks() {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(new JKSKeystoreBuilder().build()));
    }

    public JksNested<A> editOrNewJksLike(JKSKeystore item) {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(item));
    }

    public PKCS12Keystore buildPkcs12() {
        return this.pkcs12 != null ? this.pkcs12.build() : null;
    }

    public A withPkcs12(PKCS12Keystore pkcs12) {
        this._visitables.get((Object)"pkcs12").remove((Object)this.pkcs12);
        if (pkcs12 != null) {
            this.pkcs12 = new PKCS12KeystoreBuilder(pkcs12);
            this._visitables.get((Object)"pkcs12").add(this.pkcs12);
        } else {
            this.pkcs12 = null;
            this._visitables.get((Object)"pkcs12").remove((Object)this.pkcs12);
        }
        return (A)((Object)this);
    }

    public boolean hasPkcs12() {
        return this.pkcs12 != null;
    }

    public Pkcs12Nested<A> withNewPkcs12() {
        return new Pkcs12Nested(null);
    }

    public Pkcs12Nested<A> withNewPkcs12Like(PKCS12Keystore item) {
        return new Pkcs12Nested(item);
    }

    public Pkcs12Nested<A> editPkcs12() {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(null));
    }

    public Pkcs12Nested<A> editOrNewPkcs12() {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(new PKCS12KeystoreBuilder().build()));
    }

    public Pkcs12Nested<A> editOrNewPkcs12Like(PKCS12Keystore item) {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateKeystoresFluent that = (CertificateKeystoresFluent)((Object)o);
        if (!Objects.equals((Object)this.jks, (Object)that.jks)) {
            return false;
        }
        return Objects.equals((Object)this.pkcs12, (Object)that.pkcs12);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jks, this.pkcs12, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jks != null) {
            sb.append("jks:");
            sb.append((Object)((Object)this.jks) + ",");
        }
        if (this.pkcs12 != null) {
            sb.append("pkcs12:");
            sb.append((Object)this.pkcs12);
        }
        sb.append("}");
        return sb.toString();
    }

    public class Pkcs12Nested<N>
    extends PKCS12KeystoreFluent<Pkcs12Nested<N>>
    implements Nested<N> {
        PKCS12KeystoreBuilder builder;

        Pkcs12Nested(PKCS12Keystore item) {
            this.builder = new PKCS12KeystoreBuilder(this, item);
        }

        public N and() {
            return (N)CertificateKeystoresFluent.this.withPkcs12(this.builder.build());
        }

        public N endPkcs12() {
            return this.and();
        }
    }

    public class JksNested<N>
    extends JKSKeystoreFluent<JksNested<N>>
    implements Nested<N> {
        JKSKeystoreBuilder builder;

        JksNested(JKSKeystore item) {
            this.builder = new JKSKeystoreBuilder(this, item);
        }

        public N and() {
            return (N)CertificateKeystoresFluent.this.withJks(this.builder.build());
        }

        public N endJks() {
            return this.and();
        }
    }
}

