/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.IssuerSpec;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class IssuerSpecBuilder
extends IssuerSpecFluent<IssuerSpecBuilder>
implements VisitableBuilder<IssuerSpec, IssuerSpecBuilder> {
    IssuerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IssuerSpecBuilder() {
        this(false);
    }

    public IssuerSpecBuilder(Boolean validationEnabled) {
        this(new IssuerSpec(), validationEnabled);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IssuerSpec(), validationEnabled);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent, IssuerSpec instance) {
        this(fluent, instance, false);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent, IssuerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        IssuerSpec issuerSpec = instance = instance != null ? instance : new IssuerSpec();
        if (instance != null) {
            fluent.withAcme(instance.getAcme());
            fluent.withCa(instance.getCa());
            fluent.withSelfSigned(instance.getSelfSigned());
            fluent.withVault(instance.getVault());
            fluent.withVenafi(instance.getVenafi());
            fluent.withAcme(instance.getAcme());
            fluent.withCa(instance.getCa());
            fluent.withSelfSigned(instance.getSelfSigned());
            fluent.withVault(instance.getVault());
            fluent.withVenafi(instance.getVenafi());
        }
        this.validationEnabled = validationEnabled;
    }

    public IssuerSpecBuilder(IssuerSpec instance) {
        this(instance, (Boolean)false);
    }

    public IssuerSpecBuilder(IssuerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        IssuerSpec issuerSpec = instance = instance != null ? instance : new IssuerSpec();
        if (instance != null) {
            this.withAcme(instance.getAcme());
            this.withCa(instance.getCa());
            this.withSelfSigned(instance.getSelfSigned());
            this.withVault(instance.getVault());
            this.withVenafi(instance.getVenafi());
            this.withAcme(instance.getAcme());
            this.withCa(instance.getCa());
            this.withSelfSigned(instance.getSelfSigned());
            this.withVault(instance.getVault());
            this.withVenafi(instance.getVenafi());
        }
        this.validationEnabled = validationEnabled;
    }

    public IssuerSpec build() {
        IssuerSpec buildable = new IssuerSpec(this.fluent.buildAcme(), this.fluent.buildCa(), this.fluent.buildSelfSigned(), this.fluent.buildVault(), this.fluent.buildVenafi());
        return buildable;
    }
}

