package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VaultAuthFluent<A extends VaultAuthFluent<A>> extends BaseFluent<A>{
  public VaultAuthFluent() {
  }
  public VaultAuthFluent(VaultAuth instance) {
    instance = (instance != null ? instance : new VaultAuth());

    if (instance != null) {
      this.withAppRole(instance.getAppRole());
      this.withKubernetes(instance.getKubernetes());
      this.withTokenSecretRef(instance.getTokenSecretRef());
      this.withAppRole(instance.getAppRole());
      this.withKubernetes(instance.getKubernetes());
      this.withTokenSecretRef(instance.getTokenSecretRef());
    }
  }
  private VaultAppRoleBuilder appRole;
  private VaultKubernetesAuthBuilder kubernetes;
  private SecretKeySelectorBuilder tokenSecretRef;
  public VaultAppRole buildAppRole() {
    return this.appRole!=null ?this.appRole.build():null;
  }
  public A withAppRole(VaultAppRole appRole) {
    _visitables.get("appRole").remove(this.appRole);
    if (appRole!=null){ this.appRole= new VaultAppRoleBuilder(appRole); _visitables.get("appRole").add(this.appRole);} else { this.appRole = null; _visitables.get("appRole").remove(this.appRole); } return (A) this;
  }
  public boolean hasAppRole() {
    return this.appRole != null;
  }
  public AppRoleNested<A> withNewAppRole() {
    return new AppRoleNested(null);
  }
  public AppRoleNested<A> withNewAppRoleLike(VaultAppRole item) {
    return new AppRoleNested(item);
  }
  public AppRoleNested<A> editAppRole() {
    return withNewAppRoleLike(java.util.Optional.ofNullable(buildAppRole()).orElse(null));
  }
  public AppRoleNested<A> editOrNewAppRole() {
    return withNewAppRoleLike(java.util.Optional.ofNullable(buildAppRole()).orElse(new VaultAppRoleBuilder().build()));
  }
  public AppRoleNested<A> editOrNewAppRoleLike(VaultAppRole item) {
    return withNewAppRoleLike(java.util.Optional.ofNullable(buildAppRole()).orElse(item));
  }
  public VaultKubernetesAuth buildKubernetes() {
    return this.kubernetes!=null ?this.kubernetes.build():null;
  }
  public A withKubernetes(VaultKubernetesAuth kubernetes) {
    _visitables.get("kubernetes").remove(this.kubernetes);
    if (kubernetes!=null){ this.kubernetes= new VaultKubernetesAuthBuilder(kubernetes); _visitables.get("kubernetes").add(this.kubernetes);} else { this.kubernetes = null; _visitables.get("kubernetes").remove(this.kubernetes); } return (A) this;
  }
  public boolean hasKubernetes() {
    return this.kubernetes != null;
  }
  public KubernetesNested<A> withNewKubernetes() {
    return new KubernetesNested(null);
  }
  public KubernetesNested<A> withNewKubernetesLike(VaultKubernetesAuth item) {
    return new KubernetesNested(item);
  }
  public KubernetesNested<A> editKubernetes() {
    return withNewKubernetesLike(java.util.Optional.ofNullable(buildKubernetes()).orElse(null));
  }
  public KubernetesNested<A> editOrNewKubernetes() {
    return withNewKubernetesLike(java.util.Optional.ofNullable(buildKubernetes()).orElse(new VaultKubernetesAuthBuilder().build()));
  }
  public KubernetesNested<A> editOrNewKubernetesLike(VaultKubernetesAuth item) {
    return withNewKubernetesLike(java.util.Optional.ofNullable(buildKubernetes()).orElse(item));
  }
  public SecretKeySelector buildTokenSecretRef() {
    return this.tokenSecretRef!=null ?this.tokenSecretRef.build():null;
  }
  public A withTokenSecretRef(SecretKeySelector tokenSecretRef) {
    _visitables.get("tokenSecretRef").remove(this.tokenSecretRef);
    if (tokenSecretRef!=null){ this.tokenSecretRef= new SecretKeySelectorBuilder(tokenSecretRef); _visitables.get("tokenSecretRef").add(this.tokenSecretRef);} else { this.tokenSecretRef = null; _visitables.get("tokenSecretRef").remove(this.tokenSecretRef); } return (A) this;
  }
  public boolean hasTokenSecretRef() {
    return this.tokenSecretRef != null;
  }
  public A withNewTokenSecretRef(String key,String name) {
    return (A)withTokenSecretRef(new SecretKeySelector(key, name));
  }
  public TokenSecretRefNested<A> withNewTokenSecretRef() {
    return new TokenSecretRefNested(null);
  }
  public TokenSecretRefNested<A> withNewTokenSecretRefLike(SecretKeySelector item) {
    return new TokenSecretRefNested(item);
  }
  public TokenSecretRefNested<A> editTokenSecretRef() {
    return withNewTokenSecretRefLike(java.util.Optional.ofNullable(buildTokenSecretRef()).orElse(null));
  }
  public TokenSecretRefNested<A> editOrNewTokenSecretRef() {
    return withNewTokenSecretRefLike(java.util.Optional.ofNullable(buildTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  public TokenSecretRefNested<A> editOrNewTokenSecretRefLike(SecretKeySelector item) {
    return withNewTokenSecretRefLike(java.util.Optional.ofNullable(buildTokenSecretRef()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VaultAuthFluent that = (VaultAuthFluent) o;
    if (!java.util.Objects.equals(appRole, that.appRole)) return false;

    if (!java.util.Objects.equals(kubernetes, that.kubernetes)) return false;

    if (!java.util.Objects.equals(tokenSecretRef, that.tokenSecretRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(appRole,  kubernetes,  tokenSecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (appRole != null) { sb.append("appRole:"); sb.append(appRole + ","); }
    if (kubernetes != null) { sb.append("kubernetes:"); sb.append(kubernetes + ","); }
    if (tokenSecretRef != null) { sb.append("tokenSecretRef:"); sb.append(tokenSecretRef); }
    sb.append("}");
    return sb.toString();
  }
  public class AppRoleNested<N> extends VaultAppRoleFluent<AppRoleNested<N>> implements Nested<N>{
    AppRoleNested(VaultAppRole item) {
      this.builder = new VaultAppRoleBuilder(this, item);
    }
    VaultAppRoleBuilder builder;
    public N and() {
      return (N) VaultAuthFluent.this.withAppRole(builder.build());
    }
    public N endAppRole() {
      return and();
    }
    
  }
  public class KubernetesNested<N> extends VaultKubernetesAuthFluent<KubernetesNested<N>> implements Nested<N>{
    KubernetesNested(VaultKubernetesAuth item) {
      this.builder = new VaultKubernetesAuthBuilder(this, item);
    }
    VaultKubernetesAuthBuilder builder;
    public N and() {
      return (N) VaultAuthFluent.this.withKubernetes(builder.build());
    }
    public N endKubernetes() {
      return and();
    }
    
  }
  public class TokenSecretRefNested<N> extends SecretKeySelectorFluent<TokenSecretRefNested<N>> implements Nested<N>{
    TokenSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) VaultAuthFluent.this.withTokenSecretRef(builder.build());
    }
    public N endTokenSecretRef() {
      return and();
    }
    
  }
  
}