package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSignedIssuerBuilder extends SelfSignedIssuerFluent<SelfSignedIssuerBuilder> implements VisitableBuilder<SelfSignedIssuer,SelfSignedIssuerBuilder>{
  public SelfSignedIssuerBuilder() {
    this(false);
  }
  public SelfSignedIssuerBuilder(Boolean validationEnabled) {
    this(new SelfSignedIssuer(), validationEnabled);
  }
  public SelfSignedIssuerBuilder(SelfSignedIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSignedIssuerBuilder(SelfSignedIssuerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelfSignedIssuer(), validationEnabled);
  }
  public SelfSignedIssuerBuilder(SelfSignedIssuerFluent<?> fluent,SelfSignedIssuer instance) {
    this(fluent, instance, false);
  }
  public SelfSignedIssuerBuilder(SelfSignedIssuerFluent<?> fluent,SelfSignedIssuer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SelfSignedIssuer());

    if (instance != null) {
      fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints());
      fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelfSignedIssuerBuilder(SelfSignedIssuer instance) {
    this(instance,false);
  }
  public SelfSignedIssuerBuilder(SelfSignedIssuer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SelfSignedIssuer());

    if (instance != null) {
      this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
      this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelfSignedIssuerFluent<?> fluent;
  Boolean validationEnabled;
  public SelfSignedIssuer build() {
    SelfSignedIssuer buildable = new SelfSignedIssuer(fluent.getCrlDistributionPoints());
    return buildable;
  }
  
}