package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PKCS12KeystoreFluent<A extends PKCS12KeystoreFluent<A>> extends BaseFluent<A>{
  public PKCS12KeystoreFluent() {
  }
  public PKCS12KeystoreFluent(PKCS12Keystore instance) {
    instance = (instance != null ? instance : new PKCS12Keystore());

    if (instance != null) {
      this.withCreate(instance.getCreate());
      this.withPasswordSecretRef(instance.getPasswordSecretRef());
      this.withCreate(instance.getCreate());
      this.withPasswordSecretRef(instance.getPasswordSecretRef());
    }
  }
  private Boolean create;
  private SecretKeySelectorBuilder passwordSecretRef;
  public Boolean getCreate() {
    return this.create;
  }
  public A withCreate(Boolean create) {
    this.create=create; return (A) this;
  }
  public boolean hasCreate() {
    return this.create != null;
  }
  public SecretKeySelector buildPasswordSecretRef() {
    return this.passwordSecretRef!=null ?this.passwordSecretRef.build():null;
  }
  public A withPasswordSecretRef(SecretKeySelector passwordSecretRef) {
    _visitables.get("passwordSecretRef").remove(this.passwordSecretRef);
    if (passwordSecretRef!=null){ this.passwordSecretRef= new SecretKeySelectorBuilder(passwordSecretRef); _visitables.get("passwordSecretRef").add(this.passwordSecretRef);} else { this.passwordSecretRef = null; _visitables.get("passwordSecretRef").remove(this.passwordSecretRef); } return (A) this;
  }
  public boolean hasPasswordSecretRef() {
    return this.passwordSecretRef != null;
  }
  public A withNewPasswordSecretRef(String key,String name) {
    return (A)withPasswordSecretRef(new SecretKeySelector(key, name));
  }
  public PasswordSecretRefNested<A> withNewPasswordSecretRef() {
    return new PasswordSecretRefNested(null);
  }
  public PasswordSecretRefNested<A> withNewPasswordSecretRefLike(SecretKeySelector item) {
    return new PasswordSecretRefNested(item);
  }
  public PasswordSecretRefNested<A> editPasswordSecretRef() {
    return withNewPasswordSecretRefLike(java.util.Optional.ofNullable(buildPasswordSecretRef()).orElse(null));
  }
  public PasswordSecretRefNested<A> editOrNewPasswordSecretRef() {
    return withNewPasswordSecretRefLike(java.util.Optional.ofNullable(buildPasswordSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  public PasswordSecretRefNested<A> editOrNewPasswordSecretRefLike(SecretKeySelector item) {
    return withNewPasswordSecretRefLike(java.util.Optional.ofNullable(buildPasswordSecretRef()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PKCS12KeystoreFluent that = (PKCS12KeystoreFluent) o;
    if (!java.util.Objects.equals(create, that.create)) return false;

    if (!java.util.Objects.equals(passwordSecretRef, that.passwordSecretRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(create,  passwordSecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (create != null) { sb.append("create:"); sb.append(create + ","); }
    if (passwordSecretRef != null) { sb.append("passwordSecretRef:"); sb.append(passwordSecretRef); }
    sb.append("}");
    return sb.toString();
  }
  public A withCreate() {
    return withCreate(true);
  }
  public class PasswordSecretRefNested<N> extends SecretKeySelectorFluent<PasswordSecretRefNested<N>> implements Nested<N>{
    PasswordSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) PKCS12KeystoreFluent.this.withPasswordSecretRef(builder.build());
    }
    public N endPasswordSecretRef() {
      return and();
    }
    
  }
  
}