package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateStatusBuilder extends CertificateStatusFluent<CertificateStatusBuilder> implements VisitableBuilder<CertificateStatus,CertificateStatusBuilder>{
  public CertificateStatusBuilder() {
    this(false);
  }
  public CertificateStatusBuilder(Boolean validationEnabled) {
    this(new CertificateStatus(), validationEnabled);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateStatus(), validationEnabled);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent,CertificateStatus instance) {
    this(fluent, instance, false);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent,CertificateStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withLastFailureTime(instance.getLastFailureTime());
      fluent.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName());
      fluent.withNotAfter(instance.getNotAfter());
      fluent.withNotBefore(instance.getNotBefore());
      fluent.withRenewalTime(instance.getRenewalTime());
      fluent.withRevision(instance.getRevision());
      fluent.withConditions(instance.getConditions());
      fluent.withLastFailureTime(instance.getLastFailureTime());
      fluent.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName());
      fluent.withNotAfter(instance.getNotAfter());
      fluent.withNotBefore(instance.getNotBefore());
      fluent.withRenewalTime(instance.getRenewalTime());
      fluent.withRevision(instance.getRevision());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateStatusBuilder(CertificateStatus instance) {
    this(instance,false);
  }
  public CertificateStatusBuilder(CertificateStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withLastFailureTime(instance.getLastFailureTime());
      this.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName());
      this.withNotAfter(instance.getNotAfter());
      this.withNotBefore(instance.getNotBefore());
      this.withRenewalTime(instance.getRenewalTime());
      this.withRevision(instance.getRevision());
      this.withConditions(instance.getConditions());
      this.withLastFailureTime(instance.getLastFailureTime());
      this.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName());
      this.withNotAfter(instance.getNotAfter());
      this.withNotBefore(instance.getNotBefore());
      this.withRenewalTime(instance.getRenewalTime());
      this.withRevision(instance.getRevision());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateStatus build() {
    CertificateStatus buildable = new CertificateStatus(fluent.buildConditions(),fluent.getLastFailureTime(),fluent.getNextPrivateKeySecretName(),fluent.getNotAfter(),fluent.getNotBefore(),fluent.getRenewalTime(),fluent.getRevision());
    return buildable;
  }
  
}