package io.fabric8.certmanager.api.model.meta.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretKeySelectorBuilder extends SecretKeySelectorFluent<SecretKeySelectorBuilder> implements VisitableBuilder<SecretKeySelector,SecretKeySelectorBuilder>{
  public SecretKeySelectorBuilder() {
    this(false);
  }
  public SecretKeySelectorBuilder(Boolean validationEnabled) {
    this(new SecretKeySelector(), validationEnabled);
  }
  public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretKeySelector(), validationEnabled);
  }
  public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent,SecretKeySelector instance) {
    this(fluent, instance, false);
  }
  public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent,SecretKeySelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecretKeySelector());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretKeySelectorBuilder(SecretKeySelector instance) {
    this(instance,false);
  }
  public SecretKeySelectorBuilder(SecretKeySelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecretKeySelector());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withName(instance.getName());
      this.withKey(instance.getKey());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretKeySelectorFluent<?> fluent;
  Boolean validationEnabled;
  public SecretKeySelector build() {
    SecretKeySelector buildable = new SecretKeySelector(fluent.getKey(),fluent.getName());
    return buildable;
  }
  
}