package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OrderSpecFluent<A extends OrderSpecFluent<A>> extends BaseFluent<A>{
  public OrderSpecFluent() {
  }
  public OrderSpecFluent(OrderSpec instance) {
    instance = (instance != null ? instance : new OrderSpec());

    if (instance != null) {
      this.withCommonName(instance.getCommonName());
      this.withCsr(instance.getCsr());
      this.withDnsNames(instance.getDnsNames());
      this.withDuration(instance.getDuration());
      this.withIpAddresses(instance.getIpAddresses());
      this.withIssuerRef(instance.getIssuerRef());
      this.withCommonName(instance.getCommonName());
      this.withCsr(instance.getCsr());
      this.withDnsNames(instance.getDnsNames());
      this.withDuration(instance.getDuration());
      this.withIpAddresses(instance.getIpAddresses());
      this.withIssuerRef(instance.getIssuerRef());
    }
  }
  private String commonName;
  private String csr;
  private List<String> dnsNames = new ArrayList<String>();
  private Duration duration;
  private List<String> ipAddresses = new ArrayList<String>();
  private ObjectReferenceBuilder issuerRef;
  public String getCommonName() {
    return this.commonName;
  }
  public A withCommonName(String commonName) {
    this.commonName=commonName; return (A) this;
  }
  public boolean hasCommonName() {
    return this.commonName != null;
  }
  public String getCsr() {
    return this.csr;
  }
  public A withCsr(String csr) {
    this.csr=csr; return (A) this;
  }
  public boolean hasCsr() {
    return this.csr != null;
  }
  public A addToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(int index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear(); _visitables.remove("dnsNames"); }
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public boolean hasDuration() {
    return this.duration != null;
  }
  public A addToIpAddresses(int index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.add(index, item);
    return (A)this;
  }
  public A setToIpAddresses(int index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.set(index, item); return (A)this;
  }
  public A addToIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A addAllToIpAddresses(Collection<String> items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A removeFromIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) return (A)this;
    for (String item : items) { this.ipAddresses.remove(item);} return (A)this;
  }
  public A removeAllFromIpAddresses(Collection<String> items) {
    if (this.ipAddresses == null) return (A)this;
    for (String item : items) { this.ipAddresses.remove(item);} return (A)this;
  }
  public List<String> getIpAddresses() {
    return this.ipAddresses;
  }
  public String getIpAddress(int index) {
    return this.ipAddresses.get(index);
  }
  public String getFirstIpAddress() {
    return this.ipAddresses.get(0);
  }
  public String getLastIpAddress() {
    return this.ipAddresses.get(ipAddresses.size() - 1);
  }
  public String getMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpAddresses(List<String> ipAddresses) {
    if (ipAddresses != null) {this.ipAddresses = new ArrayList(); for (String item : ipAddresses){this.addToIpAddresses(item);}} else { this.ipAddresses = null;} return (A) this;
  }
  public A withIpAddresses(java.lang.String... ipAddresses) {
    if (this.ipAddresses != null) {this.ipAddresses.clear(); _visitables.remove("ipAddresses"); }
    if (ipAddresses != null) {for (String item :ipAddresses){ this.addToIpAddresses(item);}} return (A) this;
  }
  public boolean hasIpAddresses() {
    return ipAddresses != null && !ipAddresses.isEmpty();
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public IssuerRefNested<A> withNewIssuerRef() {
    return new IssuerRefNested(null);
  }
  public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new IssuerRefNested(item);
  }
  public IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(null));
  }
  public IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OrderSpecFluent that = (OrderSpecFluent) o;
    if (!java.util.Objects.equals(commonName, that.commonName)) return false;

    if (!java.util.Objects.equals(csr, that.csr)) return false;

    if (!java.util.Objects.equals(dnsNames, that.dnsNames)) return false;

    if (!java.util.Objects.equals(duration, that.duration)) return false;

    if (!java.util.Objects.equals(ipAddresses, that.ipAddresses)) return false;

    if (!java.util.Objects.equals(issuerRef, that.issuerRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(commonName,  csr,  dnsNames,  duration,  ipAddresses,  issuerRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (csr != null) { sb.append("csr:"); sb.append(csr + ","); }
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (ipAddresses != null && !ipAddresses.isEmpty()) { sb.append("ipAddresses:"); sb.append(ipAddresses + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef); }
    sb.append("}");
    return sb.toString();
  }
  public class IssuerRefNested<N> extends ObjectReferenceFluent<IssuerRefNested<N>> implements Nested<N>{
    IssuerRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) OrderSpecFluent.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  
}