package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OrderListBuilder extends OrderListFluent<OrderListBuilder> implements VisitableBuilder<OrderList,OrderListBuilder>{
  public OrderListBuilder() {
    this(false);
  }
  public OrderListBuilder(Boolean validationEnabled) {
    this(new OrderList(), validationEnabled);
  }
  public OrderListBuilder(OrderListFluent<?> fluent) {
    this(fluent, false);
  }
  public OrderListBuilder(OrderListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OrderList(), validationEnabled);
  }
  public OrderListBuilder(OrderListFluent<?> fluent,OrderList instance) {
    this(fluent, instance, false);
  }
  public OrderListBuilder(OrderListFluent<?> fluent,OrderList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OrderList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OrderListBuilder(OrderList instance) {
    this(instance,false);
  }
  public OrderListBuilder(OrderList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OrderList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  OrderListFluent<?> fluent;
  Boolean validationEnabled;
  public OrderList build() {
    OrderList buildable = new OrderList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}