package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChallengeSpecBuilder extends ChallengeSpecFluent<ChallengeSpecBuilder> implements VisitableBuilder<ChallengeSpec,ChallengeSpecBuilder>{
  public ChallengeSpecBuilder() {
    this(false);
  }
  public ChallengeSpecBuilder(Boolean validationEnabled) {
    this(new ChallengeSpec(), validationEnabled);
  }
  public ChallengeSpecBuilder(ChallengeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ChallengeSpecBuilder(ChallengeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChallengeSpec(), validationEnabled);
  }
  public ChallengeSpecBuilder(ChallengeSpecFluent<?> fluent,ChallengeSpec instance) {
    this(fluent, instance, false);
  }
  public ChallengeSpecBuilder(ChallengeSpecFluent<?> fluent,ChallengeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ChallengeSpec());

    if (instance != null) {
      fluent.withAuthzURL(instance.getAuthzURL());
      fluent.withDnsName(instance.getDnsName());
      fluent.withIssuerRef(instance.getIssuerRef());
      fluent.withKey(instance.getKey());
      fluent.withSolver(instance.getSolver());
      fluent.withToken(instance.getToken());
      fluent.withType(instance.getType());
      fluent.withUrl(instance.getUrl());
      fluent.withWildcard(instance.getWildcard());
      fluent.withAuthzURL(instance.getAuthzURL());
      fluent.withDnsName(instance.getDnsName());
      fluent.withIssuerRef(instance.getIssuerRef());
      fluent.withKey(instance.getKey());
      fluent.withSolver(instance.getSolver());
      fluent.withToken(instance.getToken());
      fluent.withType(instance.getType());
      fluent.withUrl(instance.getUrl());
      fluent.withWildcard(instance.getWildcard());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChallengeSpecBuilder(ChallengeSpec instance) {
    this(instance,false);
  }
  public ChallengeSpecBuilder(ChallengeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ChallengeSpec());

    if (instance != null) {
      this.withAuthzURL(instance.getAuthzURL());
      this.withDnsName(instance.getDnsName());
      this.withIssuerRef(instance.getIssuerRef());
      this.withKey(instance.getKey());
      this.withSolver(instance.getSolver());
      this.withToken(instance.getToken());
      this.withType(instance.getType());
      this.withUrl(instance.getUrl());
      this.withWildcard(instance.getWildcard());
      this.withAuthzURL(instance.getAuthzURL());
      this.withDnsName(instance.getDnsName());
      this.withIssuerRef(instance.getIssuerRef());
      this.withKey(instance.getKey());
      this.withSolver(instance.getSolver());
      this.withToken(instance.getToken());
      this.withType(instance.getType());
      this.withUrl(instance.getUrl());
      this.withWildcard(instance.getWildcard());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChallengeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ChallengeSpec build() {
    ChallengeSpec buildable = new ChallengeSpec(fluent.getAuthzURL(),fluent.getDnsName(),fluent.buildIssuerRef(),fluent.getKey(),fluent.buildSolver(),fluent.getToken(),fluent.getType(),fluent.getUrl(),fluent.getWildcard());
    return buildable;
  }
  
}