package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateDNSNameSelectorFluent<A extends CertificateDNSNameSelectorFluent<A>> extends BaseFluent<A>{
  public CertificateDNSNameSelectorFluent() {
  }
  public CertificateDNSNameSelectorFluent(CertificateDNSNameSelector instance) {
    instance = (instance != null ? instance : new CertificateDNSNameSelector());

    if (instance != null) {
      this.withDnsNames(instance.getDnsNames());
      this.withDnsZones(instance.getDnsZones());
      this.withMatchLabels(instance.getMatchLabels());
      this.withDnsNames(instance.getDnsNames());
      this.withDnsZones(instance.getDnsZones());
      this.withMatchLabels(instance.getMatchLabels());
    }
  }
  private List<String> dnsNames = new ArrayList<String>();
  private List<String> dnsZones = new ArrayList<String>();
  private Map<String,String> matchLabels;
  public A addToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(int index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear(); _visitables.remove("dnsNames"); }
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public A addToDnsZones(int index,String item) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    this.dnsZones.add(index, item);
    return (A)this;
  }
  public A setToDnsZones(int index,String item) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    this.dnsZones.set(index, item); return (A)this;
  }
  public A addToDnsZones(java.lang.String... items) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    for (String item : items) {this.dnsZones.add(item);} return (A)this;
  }
  public A addAllToDnsZones(Collection<String> items) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    for (String item : items) {this.dnsZones.add(item);} return (A)this;
  }
  public A removeFromDnsZones(java.lang.String... items) {
    if (this.dnsZones == null) return (A)this;
    for (String item : items) { this.dnsZones.remove(item);} return (A)this;
  }
  public A removeAllFromDnsZones(Collection<String> items) {
    if (this.dnsZones == null) return (A)this;
    for (String item : items) { this.dnsZones.remove(item);} return (A)this;
  }
  public List<String> getDnsZones() {
    return this.dnsZones;
  }
  public String getDnsZone(int index) {
    return this.dnsZones.get(index);
  }
  public String getFirstDnsZone() {
    return this.dnsZones.get(0);
  }
  public String getLastDnsZone() {
    return this.dnsZones.get(dnsZones.size() - 1);
  }
  public String getMatchingDnsZone(Predicate<String> predicate) {
    for (String item: dnsZones) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingDnsZone(Predicate<String> predicate) {
    for (String item: dnsZones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsZones(List<String> dnsZones) {
    if (dnsZones != null) {this.dnsZones = new ArrayList(); for (String item : dnsZones){this.addToDnsZones(item);}} else { this.dnsZones = null;} return (A) this;
  }
  public A withDnsZones(java.lang.String... dnsZones) {
    if (this.dnsZones != null) {this.dnsZones.clear(); _visitables.remove("dnsZones"); }
    if (dnsZones != null) {for (String item :dnsZones){ this.addToDnsZones(item);}} return (A) this;
  }
  public boolean hasDnsZones() {
    return dnsZones != null && !dnsZones.isEmpty();
  }
  public A addToMatchLabels(String key,String value) {
    if(this.matchLabels == null && key != null && value != null) { this.matchLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
  }
  public A addToMatchLabels(Map<String,String> map) {
    if(this.matchLabels == null && map != null) { this.matchLabels = new LinkedHashMap(); }
    if(map != null) { this.matchLabels.putAll(map);} return (A)this;
  }
  public A removeFromMatchLabels(String key) {
    if(this.matchLabels == null) { return (A) this; }
    if(key != null && this.matchLabels != null) {this.matchLabels.remove(key);} return (A)this;
  }
  public A removeFromMatchLabels(Map<String,String> map) {
    if(this.matchLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.matchLabels != null){this.matchLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getMatchLabels() {
    return this.matchLabels;
  }
  public <K,V>A withMatchLabels(Map<String,String> matchLabels) {
    if (matchLabels == null) { this.matchLabels =  null;} else {this.matchLabels = new LinkedHashMap(matchLabels);} return (A) this;
  }
  public boolean hasMatchLabels() {
    return this.matchLabels != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateDNSNameSelectorFluent that = (CertificateDNSNameSelectorFluent) o;
    if (!java.util.Objects.equals(dnsNames, that.dnsNames)) return false;

    if (!java.util.Objects.equals(dnsZones, that.dnsZones)) return false;

    if (!java.util.Objects.equals(matchLabels, that.matchLabels)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dnsNames,  dnsZones,  matchLabels,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (dnsZones != null && !dnsZones.isEmpty()) { sb.append("dnsZones:"); sb.append(dnsZones + ","); }
    if (matchLabels != null && !matchLabels.isEmpty()) { sb.append("matchLabels:"); sb.append(matchLabels); }
    sb.append("}");
    return sb.toString();
  }
  
}