package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerFluent<A extends ACMEIssuerFluent<A>> extends BaseFluent<A>{
  public ACMEIssuerFluent() {
  }
  public ACMEIssuerFluent(ACMEIssuer instance) {
    instance = (instance != null ? instance : new ACMEIssuer());

    if (instance != null) {
      this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration());
      this.withEmail(instance.getEmail());
      this.withEnableDurationFeature(instance.getEnableDurationFeature());
      this.withExternalAccountBinding(instance.getExternalAccountBinding());
      this.withPreferredChain(instance.getPreferredChain());
      this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef());
      this.withServer(instance.getServer());
      this.withSkipTLSVerify(instance.getSkipTLSVerify());
      this.withSolvers(instance.getSolvers());
      this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration());
      this.withEmail(instance.getEmail());
      this.withEnableDurationFeature(instance.getEnableDurationFeature());
      this.withExternalAccountBinding(instance.getExternalAccountBinding());
      this.withPreferredChain(instance.getPreferredChain());
      this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef());
      this.withServer(instance.getServer());
      this.withSkipTLSVerify(instance.getSkipTLSVerify());
      this.withSolvers(instance.getSolvers());
    }
  }
  private Boolean disableAccountKeyGeneration;
  private String email;
  private Boolean enableDurationFeature;
  private ACMEExternalAccountBindingBuilder externalAccountBinding;
  private String preferredChain;
  private SecretKeySelectorBuilder privateKeySecretRef;
  private String server;
  private Boolean skipTLSVerify;
  private ArrayList<ACMEChallengeSolverBuilder> solvers = new ArrayList<ACMEChallengeSolverBuilder>();
  public Boolean getDisableAccountKeyGeneration() {
    return this.disableAccountKeyGeneration;
  }
  public A withDisableAccountKeyGeneration(Boolean disableAccountKeyGeneration) {
    this.disableAccountKeyGeneration=disableAccountKeyGeneration; return (A) this;
  }
  public boolean hasDisableAccountKeyGeneration() {
    return this.disableAccountKeyGeneration != null;
  }
  public String getEmail() {
    return this.email;
  }
  public A withEmail(String email) {
    this.email=email; return (A) this;
  }
  public boolean hasEmail() {
    return this.email != null;
  }
  public Boolean getEnableDurationFeature() {
    return this.enableDurationFeature;
  }
  public A withEnableDurationFeature(Boolean enableDurationFeature) {
    this.enableDurationFeature=enableDurationFeature; return (A) this;
  }
  public boolean hasEnableDurationFeature() {
    return this.enableDurationFeature != null;
  }
  public ACMEExternalAccountBinding buildExternalAccountBinding() {
    return this.externalAccountBinding!=null ?this.externalAccountBinding.build():null;
  }
  public A withExternalAccountBinding(ACMEExternalAccountBinding externalAccountBinding) {
    _visitables.get("externalAccountBinding").remove(this.externalAccountBinding);
    if (externalAccountBinding!=null){ this.externalAccountBinding= new ACMEExternalAccountBindingBuilder(externalAccountBinding); _visitables.get("externalAccountBinding").add(this.externalAccountBinding);} else { this.externalAccountBinding = null; _visitables.get("externalAccountBinding").remove(this.externalAccountBinding); } return (A) this;
  }
  public boolean hasExternalAccountBinding() {
    return this.externalAccountBinding != null;
  }
  public ExternalAccountBindingNested<A> withNewExternalAccountBinding() {
    return new ExternalAccountBindingNested(null);
  }
  public ExternalAccountBindingNested<A> withNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
    return new ExternalAccountBindingNested(item);
  }
  public ExternalAccountBindingNested<A> editExternalAccountBinding() {
    return withNewExternalAccountBindingLike(java.util.Optional.ofNullable(buildExternalAccountBinding()).orElse(null));
  }
  public ExternalAccountBindingNested<A> editOrNewExternalAccountBinding() {
    return withNewExternalAccountBindingLike(java.util.Optional.ofNullable(buildExternalAccountBinding()).orElse(new ACMEExternalAccountBindingBuilder().build()));
  }
  public ExternalAccountBindingNested<A> editOrNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
    return withNewExternalAccountBindingLike(java.util.Optional.ofNullable(buildExternalAccountBinding()).orElse(item));
  }
  public String getPreferredChain() {
    return this.preferredChain;
  }
  public A withPreferredChain(String preferredChain) {
    this.preferredChain=preferredChain; return (A) this;
  }
  public boolean hasPreferredChain() {
    return this.preferredChain != null;
  }
  public SecretKeySelector buildPrivateKeySecretRef() {
    return this.privateKeySecretRef!=null ?this.privateKeySecretRef.build():null;
  }
  public A withPrivateKeySecretRef(SecretKeySelector privateKeySecretRef) {
    _visitables.get("privateKeySecretRef").remove(this.privateKeySecretRef);
    if (privateKeySecretRef!=null){ this.privateKeySecretRef= new SecretKeySelectorBuilder(privateKeySecretRef); _visitables.get("privateKeySecretRef").add(this.privateKeySecretRef);} else { this.privateKeySecretRef = null; _visitables.get("privateKeySecretRef").remove(this.privateKeySecretRef); } return (A) this;
  }
  public boolean hasPrivateKeySecretRef() {
    return this.privateKeySecretRef != null;
  }
  public A withNewPrivateKeySecretRef(String key,String name) {
    return (A)withPrivateKeySecretRef(new SecretKeySelector(key, name));
  }
  public PrivateKeySecretRefNested<A> withNewPrivateKeySecretRef() {
    return new PrivateKeySecretRefNested(null);
  }
  public PrivateKeySecretRefNested<A> withNewPrivateKeySecretRefLike(SecretKeySelector item) {
    return new PrivateKeySecretRefNested(item);
  }
  public PrivateKeySecretRefNested<A> editPrivateKeySecretRef() {
    return withNewPrivateKeySecretRefLike(java.util.Optional.ofNullable(buildPrivateKeySecretRef()).orElse(null));
  }
  public PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRef() {
    return withNewPrivateKeySecretRefLike(java.util.Optional.ofNullable(buildPrivateKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  public PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRefLike(SecretKeySelector item) {
    return withNewPrivateKeySecretRefLike(java.util.Optional.ofNullable(buildPrivateKeySecretRef()).orElse(item));
  }
  public String getServer() {
    return this.server;
  }
  public A withServer(String server) {
    this.server=server; return (A) this;
  }
  public boolean hasServer() {
    return this.server != null;
  }
  public Boolean getSkipTLSVerify() {
    return this.skipTLSVerify;
  }
  public A withSkipTLSVerify(Boolean skipTLSVerify) {
    this.skipTLSVerify=skipTLSVerify; return (A) this;
  }
  public boolean hasSkipTLSVerify() {
    return this.skipTLSVerify != null;
  }
  public A addToSolvers(int index,ACMEChallengeSolver item) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
    if (index < 0 || index >= solvers.size()) { _visitables.get("solvers").add(builder); solvers.add(builder); } else { _visitables.get("solvers").add(index, builder); solvers.add(index, builder);}
    return (A)this;
  }
  public A setToSolvers(int index,ACMEChallengeSolver item) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
    if (index < 0 || index >= solvers.size()) { _visitables.get("solvers").add(builder); solvers.add(builder); } else { _visitables.get("solvers").set(index, builder); solvers.set(index, builder);}
    return (A)this;
  }
  public A addToSolvers(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeSolver... items) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(builder);this.solvers.add(builder);} return (A)this;
  }
  public A addAllToSolvers(Collection<ACMEChallengeSolver> items) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(builder);this.solvers.add(builder);} return (A)this;
  }
  public A removeFromSolvers(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeSolver... items) {
    if (this.solvers == null) return (A)this;
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").remove(builder); this.solvers.remove(builder);} return (A)this;
  }
  public A removeAllFromSolvers(Collection<ACMEChallengeSolver> items) {
    if (this.solvers == null) return (A)this;
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").remove(builder); this.solvers.remove(builder);} return (A)this;
  }
  public A removeMatchingFromSolvers(Predicate<ACMEChallengeSolverBuilder> predicate) {
    if (solvers == null) return (A) this;
    final Iterator<ACMEChallengeSolverBuilder> each = solvers.iterator();
    final List visitables = _visitables.get("solvers");
    while (each.hasNext()) {
      ACMEChallengeSolverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ACMEChallengeSolver> buildSolvers() {
    return solvers != null ? build(solvers) : null;
  }
  public ACMEChallengeSolver buildSolver(int index) {
    return this.solvers.get(index).build();
  }
  public ACMEChallengeSolver buildFirstSolver() {
    return this.solvers.get(0).build();
  }
  public ACMEChallengeSolver buildLastSolver() {
    return this.solvers.get(solvers.size() - 1).build();
  }
  public ACMEChallengeSolver buildMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
    for (ACMEChallengeSolverBuilder item: solvers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
    for (ACMEChallengeSolverBuilder item: solvers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSolvers(List<ACMEChallengeSolver> solvers) {
    if (this.solvers != null) { _visitables.get("solvers").clear();}
    if (solvers != null) {this.solvers = new ArrayList(); for (ACMEChallengeSolver item : solvers){this.addToSolvers(item);}} else { this.solvers = null;} return (A) this;
  }
  public A withSolvers(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeSolver... solvers) {
    if (this.solvers != null) {this.solvers.clear(); _visitables.remove("solvers"); }
    if (solvers != null) {for (ACMEChallengeSolver item :solvers){ this.addToSolvers(item);}} return (A) this;
  }
  public boolean hasSolvers() {
    return solvers != null && !solvers.isEmpty();
  }
  public SolversNested<A> addNewSolver() {
    return new SolversNested(-1, null);
  }
  public SolversNested<A> addNewSolverLike(ACMEChallengeSolver item) {
    return new SolversNested(-1, item);
  }
  public SolversNested<A> setNewSolverLike(int index,ACMEChallengeSolver item) {
    return new SolversNested(index, item);
  }
  public SolversNested<A> editSolver(int index) {
    if (solvers.size() <= index) throw new RuntimeException("Can't edit solvers. Index exceeds size.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public SolversNested<A> editFirstSolver() {
    if (solvers.size() == 0) throw new RuntimeException("Can't edit first solvers. The list is empty.");
    return setNewSolverLike(0, buildSolver(0));
  }
  public SolversNested<A> editLastSolver() {
    int index = solvers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last solvers. The list is empty.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public SolversNested<A> editMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<solvers.size();i++) { 
    if (predicate.test(solvers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching solvers. No match found.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerFluent that = (ACMEIssuerFluent) o;
    if (!java.util.Objects.equals(disableAccountKeyGeneration, that.disableAccountKeyGeneration)) return false;

    if (!java.util.Objects.equals(email, that.email)) return false;

    if (!java.util.Objects.equals(enableDurationFeature, that.enableDurationFeature)) return false;

    if (!java.util.Objects.equals(externalAccountBinding, that.externalAccountBinding)) return false;

    if (!java.util.Objects.equals(preferredChain, that.preferredChain)) return false;

    if (!java.util.Objects.equals(privateKeySecretRef, that.privateKeySecretRef)) return false;

    if (!java.util.Objects.equals(server, that.server)) return false;

    if (!java.util.Objects.equals(skipTLSVerify, that.skipTLSVerify)) return false;

    if (!java.util.Objects.equals(solvers, that.solvers)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(disableAccountKeyGeneration,  email,  enableDurationFeature,  externalAccountBinding,  preferredChain,  privateKeySecretRef,  server,  skipTLSVerify,  solvers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disableAccountKeyGeneration != null) { sb.append("disableAccountKeyGeneration:"); sb.append(disableAccountKeyGeneration + ","); }
    if (email != null) { sb.append("email:"); sb.append(email + ","); }
    if (enableDurationFeature != null) { sb.append("enableDurationFeature:"); sb.append(enableDurationFeature + ","); }
    if (externalAccountBinding != null) { sb.append("externalAccountBinding:"); sb.append(externalAccountBinding + ","); }
    if (preferredChain != null) { sb.append("preferredChain:"); sb.append(preferredChain + ","); }
    if (privateKeySecretRef != null) { sb.append("privateKeySecretRef:"); sb.append(privateKeySecretRef + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (skipTLSVerify != null) { sb.append("skipTLSVerify:"); sb.append(skipTLSVerify + ","); }
    if (solvers != null && !solvers.isEmpty()) { sb.append("solvers:"); sb.append(solvers); }
    sb.append("}");
    return sb.toString();
  }
  public A withDisableAccountKeyGeneration() {
    return withDisableAccountKeyGeneration(true);
  }
  public A withEnableDurationFeature() {
    return withEnableDurationFeature(true);
  }
  public A withSkipTLSVerify() {
    return withSkipTLSVerify(true);
  }
  public class ExternalAccountBindingNested<N> extends ACMEExternalAccountBindingFluent<ExternalAccountBindingNested<N>> implements Nested<N>{
    ExternalAccountBindingNested(ACMEExternalAccountBinding item) {
      this.builder = new ACMEExternalAccountBindingBuilder(this, item);
    }
    ACMEExternalAccountBindingBuilder builder;
    public N and() {
      return (N) ACMEIssuerFluent.this.withExternalAccountBinding(builder.build());
    }
    public N endExternalAccountBinding() {
      return and();
    }
    
  }
  public class PrivateKeySecretRefNested<N> extends SecretKeySelectorFluent<PrivateKeySecretRefNested<N>> implements Nested<N>{
    PrivateKeySecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerFluent.this.withPrivateKeySecretRef(builder.build());
    }
    public N endPrivateKeySecretRef() {
      return and();
    }
    
  }
  public class SolversNested<N> extends ACMEChallengeSolverFluent<SolversNested<N>> implements Nested<N>{
    SolversNested(int index,ACMEChallengeSolver item) {
      this.index = index;
      this.builder = new ACMEChallengeSolverBuilder(this, item);
    }
    ACMEChallengeSolverBuilder builder;
    int index;
    public N and() {
      return (N) ACMEIssuerFluent.this.setToSolvers(index,builder.build());
    }
    public N endSolver() {
      return and();
    }
    
  }
  
}