package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEChallengeSolverBuilder extends ACMEChallengeSolverFluent<ACMEChallengeSolverBuilder> implements VisitableBuilder<ACMEChallengeSolver,ACMEChallengeSolverBuilder>{
  public ACMEChallengeSolverBuilder() {
    this(false);
  }
  public ACMEChallengeSolverBuilder(Boolean validationEnabled) {
    this(new ACMEChallengeSolver(), validationEnabled);
  }
  public ACMEChallengeSolverBuilder(ACMEChallengeSolverFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEChallengeSolverBuilder(ACMEChallengeSolverFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEChallengeSolver(), validationEnabled);
  }
  public ACMEChallengeSolverBuilder(ACMEChallengeSolverFluent<?> fluent,ACMEChallengeSolver instance) {
    this(fluent, instance, false);
  }
  public ACMEChallengeSolverBuilder(ACMEChallengeSolverFluent<?> fluent,ACMEChallengeSolver instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ACMEChallengeSolver());

    if (instance != null) {
      fluent.withDns01(instance.getDns01());
      fluent.withHttp01(instance.getHttp01());
      fluent.withSelector(instance.getSelector());
      fluent.withDns01(instance.getDns01());
      fluent.withHttp01(instance.getHttp01());
      fluent.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEChallengeSolverBuilder(ACMEChallengeSolver instance) {
    this(instance,false);
  }
  public ACMEChallengeSolverBuilder(ACMEChallengeSolver instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ACMEChallengeSolver());

    if (instance != null) {
      this.withDns01(instance.getDns01());
      this.withHttp01(instance.getHttp01());
      this.withSelector(instance.getSelector());
      this.withDns01(instance.getDns01());
      this.withHttp01(instance.getHttp01());
      this.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEChallengeSolverFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEChallengeSolver build() {
    ACMEChallengeSolver buildable = new ACMEChallengeSolver(fluent.buildDns01(),fluent.buildHttp01(),fluent.buildSelector());
    return buildable;
  }
  
}