package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterIssuerListBuilder extends ClusterIssuerListFluentImpl<ClusterIssuerListBuilder> implements VisitableBuilder<ClusterIssuerList,ClusterIssuerListBuilder>{
  public ClusterIssuerListBuilder() {
    this(false);
  }
  public ClusterIssuerListBuilder(Boolean validationEnabled) {
    this(new ClusterIssuerList(), validationEnabled);
  }
  public ClusterIssuerListBuilder(ClusterIssuerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterIssuerListBuilder(ClusterIssuerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterIssuerList(), validationEnabled);
  }
  public ClusterIssuerListBuilder(ClusterIssuerListFluent<?> fluent,ClusterIssuerList instance) {
    this(fluent, instance, false);
  }
  public ClusterIssuerListBuilder(ClusterIssuerListFluent<?> fluent,ClusterIssuerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterIssuerListBuilder(ClusterIssuerList instance) {
    this(instance,false);
  }
  public ClusterIssuerListBuilder(ClusterIssuerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterIssuerListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterIssuerList build() {
    ClusterIssuerList buildable = new ClusterIssuerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}