package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEExternalAccountBindingFluentImpl<A extends ACMEExternalAccountBindingFluent<A>> extends BaseFluent<A> implements ACMEExternalAccountBindingFluent<A>{
  public ACMEExternalAccountBindingFluentImpl() {
  }
  public ACMEExternalAccountBindingFluentImpl(ACMEExternalAccountBinding instance) {
    if (instance != null) {
      this.withKeyAlgorithm(instance.getKeyAlgorithm());
      this.withKeyID(instance.getKeyID());
      this.withKeySecretRef(instance.getKeySecretRef());
    }
  }
  private String keyAlgorithm;
  private String keyID;
  private SecretKeySelectorBuilder keySecretRef;
  public String getKeyAlgorithm() {
    return this.keyAlgorithm;
  }
  public A withKeyAlgorithm(String keyAlgorithm) {
    this.keyAlgorithm=keyAlgorithm; return (A) this;
  }
  public Boolean hasKeyAlgorithm() {
    return this.keyAlgorithm != null;
  }
  public String getKeyID() {
    return this.keyID;
  }
  public A withKeyID(String keyID) {
    this.keyID=keyID; return (A) this;
  }
  public Boolean hasKeyID() {
    return this.keyID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildKeySecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getKeySecretRef() {
    return this.keySecretRef!=null ?this.keySecretRef.build():null;
  }
  public SecretKeySelector buildKeySecretRef() {
    return this.keySecretRef!=null ?this.keySecretRef.build():null;
  }
  public A withKeySecretRef(SecretKeySelector keySecretRef) {
    _visitables.get("keySecretRef").remove(this.keySecretRef);
    if (keySecretRef!=null){ this.keySecretRef= new SecretKeySelectorBuilder(keySecretRef); _visitables.get("keySecretRef").add(this.keySecretRef);} else { this.keySecretRef = null; _visitables.get("keySecretRef").remove(this.keySecretRef); } return (A) this;
  }
  public Boolean hasKeySecretRef() {
    return this.keySecretRef != null;
  }
  public A withNewKeySecretRef(String key,String name) {
    return (A)withKeySecretRef(new SecretKeySelector(key, name));
  }
  public ACMEExternalAccountBindingFluentImpl.KeySecretRefNested<A> withNewKeySecretRef() {
    return new ACMEExternalAccountBindingFluentImpl.KeySecretRefNestedImpl();
  }
  public ACMEExternalAccountBindingFluentImpl.KeySecretRefNested<A> withNewKeySecretRefLike(SecretKeySelector item) {
    return new ACMEExternalAccountBindingFluentImpl.KeySecretRefNestedImpl(item);
  }
  public ACMEExternalAccountBindingFluentImpl.KeySecretRefNested<A> editKeySecretRef() {
    return withNewKeySecretRefLike(getKeySecretRef());
  }
  public ACMEExternalAccountBindingFluentImpl.KeySecretRefNested<A> editOrNewKeySecretRef() {
    return withNewKeySecretRefLike(getKeySecretRef() != null ? getKeySecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEExternalAccountBindingFluentImpl.KeySecretRefNested<A> editOrNewKeySecretRefLike(SecretKeySelector item) {
    return withNewKeySecretRefLike(getKeySecretRef() != null ? getKeySecretRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEExternalAccountBindingFluentImpl that = (ACMEExternalAccountBindingFluentImpl) o;
    if (!java.util.Objects.equals(keyAlgorithm, that.keyAlgorithm)) return false;

    if (!java.util.Objects.equals(keyID, that.keyID)) return false;

    if (!java.util.Objects.equals(keySecretRef, that.keySecretRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(keyAlgorithm,  keyID,  keySecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (keyAlgorithm != null) { sb.append("keyAlgorithm:"); sb.append(keyAlgorithm + ","); }
    if (keyID != null) { sb.append("keyID:"); sb.append(keyID + ","); }
    if (keySecretRef != null) { sb.append("keySecretRef:"); sb.append(keySecretRef); }
    sb.append("}");
    return sb.toString();
  }
  class KeySecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEExternalAccountBindingFluentImpl.KeySecretRefNested<N>> implements ACMEExternalAccountBindingFluentImpl.KeySecretRefNested<N>,Nested<N>{
    KeySecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    KeySecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEExternalAccountBindingFluentImpl.this.withKeySecretRef(builder.build());
    }
    public N endKeySecretRef() {
      return and();
    }
    
  }
  
}