package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PKCS12KeystoreFluentImpl<A extends PKCS12KeystoreFluent<A>> extends BaseFluent<A> implements PKCS12KeystoreFluent<A>{
  public PKCS12KeystoreFluentImpl() {
  }
  public PKCS12KeystoreFluentImpl(PKCS12Keystore instance) {
    if (instance != null) {
      this.withCreate(instance.getCreate());
      this.withPasswordSecretRef(instance.getPasswordSecretRef());
    }
  }
  private Boolean create;
  private SecretKeySelectorBuilder passwordSecretRef;
  public Boolean getCreate() {
    return this.create;
  }
  public A withCreate(Boolean create) {
    this.create=create; return (A) this;
  }
  public Boolean hasCreate() {
    return this.create != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPasswordSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getPasswordSecretRef() {
    return this.passwordSecretRef!=null ?this.passwordSecretRef.build():null;
  }
  public SecretKeySelector buildPasswordSecretRef() {
    return this.passwordSecretRef!=null ?this.passwordSecretRef.build():null;
  }
  public A withPasswordSecretRef(SecretKeySelector passwordSecretRef) {
    _visitables.get("passwordSecretRef").remove(this.passwordSecretRef);
    if (passwordSecretRef!=null){ this.passwordSecretRef= new SecretKeySelectorBuilder(passwordSecretRef); _visitables.get("passwordSecretRef").add(this.passwordSecretRef);} else { this.passwordSecretRef = null; _visitables.get("passwordSecretRef").remove(this.passwordSecretRef); } return (A) this;
  }
  public Boolean hasPasswordSecretRef() {
    return this.passwordSecretRef != null;
  }
  public A withNewPasswordSecretRef(String key,String name) {
    return (A)withPasswordSecretRef(new SecretKeySelector(key, name));
  }
  public PKCS12KeystoreFluentImpl.PasswordSecretRefNested<A> withNewPasswordSecretRef() {
    return new PKCS12KeystoreFluentImpl.PasswordSecretRefNestedImpl();
  }
  public PKCS12KeystoreFluentImpl.PasswordSecretRefNested<A> withNewPasswordSecretRefLike(SecretKeySelector item) {
    return new PKCS12KeystoreFluentImpl.PasswordSecretRefNestedImpl(item);
  }
  public PKCS12KeystoreFluentImpl.PasswordSecretRefNested<A> editPasswordSecretRef() {
    return withNewPasswordSecretRefLike(getPasswordSecretRef());
  }
  public PKCS12KeystoreFluentImpl.PasswordSecretRefNested<A> editOrNewPasswordSecretRef() {
    return withNewPasswordSecretRefLike(getPasswordSecretRef() != null ? getPasswordSecretRef(): new SecretKeySelectorBuilder().build());
  }
  public PKCS12KeystoreFluentImpl.PasswordSecretRefNested<A> editOrNewPasswordSecretRefLike(SecretKeySelector item) {
    return withNewPasswordSecretRefLike(getPasswordSecretRef() != null ? getPasswordSecretRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PKCS12KeystoreFluentImpl that = (PKCS12KeystoreFluentImpl) o;
    if (!java.util.Objects.equals(create, that.create)) return false;

    if (!java.util.Objects.equals(passwordSecretRef, that.passwordSecretRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(create,  passwordSecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (create != null) { sb.append("create:"); sb.append(create + ","); }
    if (passwordSecretRef != null) { sb.append("passwordSecretRef:"); sb.append(passwordSecretRef); }
    sb.append("}");
    return sb.toString();
  }
  public A withCreate() {
    return withCreate(true);
  }
  class PasswordSecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<PKCS12KeystoreFluentImpl.PasswordSecretRefNested<N>> implements PKCS12KeystoreFluentImpl.PasswordSecretRefNested<N>,Nested<N>{
    PasswordSecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    PasswordSecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) PKCS12KeystoreFluentImpl.this.withPasswordSecretRef(builder.build());
    }
    public N endPasswordSecretRef() {
      return and();
    }
    
  }
  
}