package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IssuerSpecBuilder extends IssuerSpecFluentImpl<IssuerSpecBuilder> implements VisitableBuilder<IssuerSpec,IssuerSpecBuilder>{
  public IssuerSpecBuilder() {
    this(false);
  }
  public IssuerSpecBuilder(Boolean validationEnabled) {
    this(new IssuerSpec(), validationEnabled);
  }
  public IssuerSpecBuilder(IssuerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IssuerSpecBuilder(IssuerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IssuerSpec(), validationEnabled);
  }
  public IssuerSpecBuilder(IssuerSpecFluent<?> fluent,IssuerSpec instance) {
    this(fluent, instance, false);
  }
  public IssuerSpecBuilder(IssuerSpecFluent<?> fluent,IssuerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAcme(instance.getAcme());
      fluent.withCa(instance.getCa());
      fluent.withSelfSigned(instance.getSelfSigned());
      fluent.withVault(instance.getVault());
      fluent.withVenafi(instance.getVenafi());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IssuerSpecBuilder(IssuerSpec instance) {
    this(instance,false);
  }
  public IssuerSpecBuilder(IssuerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAcme(instance.getAcme());
      this.withCa(instance.getCa());
      this.withSelfSigned(instance.getSelfSigned());
      this.withVault(instance.getVault());
      this.withVenafi(instance.getVenafi());
    }
    this.validationEnabled = validationEnabled; 
  }
  IssuerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IssuerSpec build() {
    IssuerSpec buildable = new IssuerSpec(fluent.getAcme(),fluent.getCa(),fluent.getSelfSigned(),fluent.getVault(),fluent.getVenafi());
    return buildable;
  }
  
}