package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChallengeListBuilder extends ChallengeListFluentImpl<ChallengeListBuilder> implements VisitableBuilder<ChallengeList,ChallengeListBuilder>{
  public ChallengeListBuilder() {
    this(false);
  }
  public ChallengeListBuilder(Boolean validationEnabled) {
    this(new ChallengeList(), validationEnabled);
  }
  public ChallengeListBuilder(ChallengeListFluent<?> fluent) {
    this(fluent, false);
  }
  public ChallengeListBuilder(ChallengeListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChallengeList(), validationEnabled);
  }
  public ChallengeListBuilder(ChallengeListFluent<?> fluent,ChallengeList instance) {
    this(fluent, instance, false);
  }
  public ChallengeListBuilder(ChallengeListFluent<?> fluent,ChallengeList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChallengeListBuilder(ChallengeList instance) {
    this(instance,false);
  }
  public ChallengeListBuilder(ChallengeList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChallengeListFluent<?> fluent;
  Boolean validationEnabled;
  public ChallengeList build() {
    ChallengeList buildable = new ChallengeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}