package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEIssuerStatusBuilder extends ACMEIssuerStatusFluentImpl<ACMEIssuerStatusBuilder> implements VisitableBuilder<ACMEIssuerStatus,ACMEIssuerStatusBuilder>{
  public ACMEIssuerStatusBuilder() {
    this(false);
  }
  public ACMEIssuerStatusBuilder(Boolean validationEnabled) {
    this(new ACMEIssuerStatus(), validationEnabled);
  }
  public ACMEIssuerStatusBuilder(ACMEIssuerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEIssuerStatusBuilder(ACMEIssuerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEIssuerStatus(), validationEnabled);
  }
  public ACMEIssuerStatusBuilder(ACMEIssuerStatusFluent<?> fluent,ACMEIssuerStatus instance) {
    this(fluent, instance, false);
  }
  public ACMEIssuerStatusBuilder(ACMEIssuerStatusFluent<?> fluent,ACMEIssuerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastRegisteredEmail(instance.getLastRegisteredEmail());
      fluent.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEIssuerStatusBuilder(ACMEIssuerStatus instance) {
    this(instance,false);
  }
  public ACMEIssuerStatusBuilder(ACMEIssuerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastRegisteredEmail(instance.getLastRegisteredEmail());
      this.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEIssuerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEIssuerStatus build() {
    ACMEIssuerStatus buildable = new ACMEIssuerStatus(fluent.getLastRegisteredEmail(),fluent.getUri());
    return buildable;
  }
  
}