package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEIssuerDNS01ProviderCloudDNSBuilder extends ACMEIssuerDNS01ProviderCloudDNSFluentImpl<ACMEIssuerDNS01ProviderCloudDNSBuilder> implements VisitableBuilder<ACMEIssuerDNS01ProviderCloudDNS,ACMEIssuerDNS01ProviderCloudDNSBuilder>{
  public ACMEIssuerDNS01ProviderCloudDNSBuilder() {
    this(false);
  }
  public ACMEIssuerDNS01ProviderCloudDNSBuilder(Boolean validationEnabled) {
    this(new ACMEIssuerDNS01ProviderCloudDNS(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderCloudDNSBuilder(ACMEIssuerDNS01ProviderCloudDNSFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEIssuerDNS01ProviderCloudDNSBuilder(ACMEIssuerDNS01ProviderCloudDNSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEIssuerDNS01ProviderCloudDNS(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderCloudDNSBuilder(ACMEIssuerDNS01ProviderCloudDNSFluent<?> fluent,ACMEIssuerDNS01ProviderCloudDNS instance) {
    this(fluent, instance, false);
  }
  public ACMEIssuerDNS01ProviderCloudDNSBuilder(ACMEIssuerDNS01ProviderCloudDNSFluent<?> fluent,ACMEIssuerDNS01ProviderCloudDNS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHostedZoneName(instance.getHostedZoneName());
      fluent.withProject(instance.getProject());
      fluent.withServiceAccountSecretRef(instance.getServiceAccountSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEIssuerDNS01ProviderCloudDNSBuilder(ACMEIssuerDNS01ProviderCloudDNS instance) {
    this(instance,false);
  }
  public ACMEIssuerDNS01ProviderCloudDNSBuilder(ACMEIssuerDNS01ProviderCloudDNS instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHostedZoneName(instance.getHostedZoneName());
      this.withProject(instance.getProject());
      this.withServiceAccountSecretRef(instance.getServiceAccountSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEIssuerDNS01ProviderCloudDNSFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEIssuerDNS01ProviderCloudDNS build() {
    ACMEIssuerDNS01ProviderCloudDNS buildable = new ACMEIssuerDNS01ProviderCloudDNS(fluent.getHostedZoneName(),fluent.getProject(),fluent.getServiceAccountSecretRef());
    return buildable;
  }
  
}