package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEIssuerDNS01ProviderAkamaiBuilder extends ACMEIssuerDNS01ProviderAkamaiFluentImpl<ACMEIssuerDNS01ProviderAkamaiBuilder> implements VisitableBuilder<ACMEIssuerDNS01ProviderAkamai,ACMEIssuerDNS01ProviderAkamaiBuilder>{
  public ACMEIssuerDNS01ProviderAkamaiBuilder() {
    this(false);
  }
  public ACMEIssuerDNS01ProviderAkamaiBuilder(Boolean validationEnabled) {
    this(new ACMEIssuerDNS01ProviderAkamai(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderAkamaiBuilder(ACMEIssuerDNS01ProviderAkamaiFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEIssuerDNS01ProviderAkamaiBuilder(ACMEIssuerDNS01ProviderAkamaiFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEIssuerDNS01ProviderAkamai(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderAkamaiBuilder(ACMEIssuerDNS01ProviderAkamaiFluent<?> fluent,ACMEIssuerDNS01ProviderAkamai instance) {
    this(fluent, instance, false);
  }
  public ACMEIssuerDNS01ProviderAkamaiBuilder(ACMEIssuerDNS01ProviderAkamaiFluent<?> fluent,ACMEIssuerDNS01ProviderAkamai instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAccessTokenSecretRef(instance.getAccessTokenSecretRef());
      fluent.withClientSecretSecretRef(instance.getClientSecretSecretRef());
      fluent.withClientTokenSecretRef(instance.getClientTokenSecretRef());
      fluent.withServiceConsumerDomain(instance.getServiceConsumerDomain());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEIssuerDNS01ProviderAkamaiBuilder(ACMEIssuerDNS01ProviderAkamai instance) {
    this(instance,false);
  }
  public ACMEIssuerDNS01ProviderAkamaiBuilder(ACMEIssuerDNS01ProviderAkamai instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAccessTokenSecretRef(instance.getAccessTokenSecretRef());
      this.withClientSecretSecretRef(instance.getClientSecretSecretRef());
      this.withClientTokenSecretRef(instance.getClientTokenSecretRef());
      this.withServiceConsumerDomain(instance.getServiceConsumerDomain());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEIssuerDNS01ProviderAkamaiFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEIssuerDNS01ProviderAkamai build() {
    ACMEIssuerDNS01ProviderAkamai buildable = new ACMEIssuerDNS01ProviderAkamai(fluent.getAccessTokenSecretRef(),fluent.getClientSecretSecretRef(),fluent.getClientTokenSecretRef(),fluent.getServiceConsumerDomain());
    return buildable;
  }
  
}