package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEExternalAccountBindingBuilder extends ACMEExternalAccountBindingFluentImpl<ACMEExternalAccountBindingBuilder> implements VisitableBuilder<ACMEExternalAccountBinding,ACMEExternalAccountBindingBuilder>{
  public ACMEExternalAccountBindingBuilder() {
    this(false);
  }
  public ACMEExternalAccountBindingBuilder(Boolean validationEnabled) {
    this(new ACMEExternalAccountBinding(), validationEnabled);
  }
  public ACMEExternalAccountBindingBuilder(ACMEExternalAccountBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEExternalAccountBindingBuilder(ACMEExternalAccountBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEExternalAccountBinding(), validationEnabled);
  }
  public ACMEExternalAccountBindingBuilder(ACMEExternalAccountBindingFluent<?> fluent,ACMEExternalAccountBinding instance) {
    this(fluent, instance, false);
  }
  public ACMEExternalAccountBindingBuilder(ACMEExternalAccountBindingFluent<?> fluent,ACMEExternalAccountBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKeyAlgorithm(instance.getKeyAlgorithm());
      fluent.withKeyID(instance.getKeyID());
      fluent.withKeySecretRef(instance.getKeySecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEExternalAccountBindingBuilder(ACMEExternalAccountBinding instance) {
    this(instance,false);
  }
  public ACMEExternalAccountBindingBuilder(ACMEExternalAccountBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKeyAlgorithm(instance.getKeyAlgorithm());
      this.withKeyID(instance.getKeyID());
      this.withKeySecretRef(instance.getKeySecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEExternalAccountBindingFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEExternalAccountBinding build() {
    ACMEExternalAccountBinding buildable = new ACMEExternalAccountBinding(fluent.getKeyAlgorithm(),fluent.getKeyID(),fluent.getKeySecretRef());
    return buildable;
  }
  
}