/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.Issuer;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerFluent;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class IssuerBuilder
extends IssuerFluentImpl<IssuerBuilder>
implements VisitableBuilder<Issuer, IssuerBuilder> {
    IssuerFluent<?> fluent;
    Boolean validationEnabled;

    public IssuerBuilder() {
        this(false);
    }

    public IssuerBuilder(Boolean validationEnabled) {
        this(new Issuer(), validationEnabled);
    }

    public IssuerBuilder(IssuerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IssuerBuilder(IssuerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Issuer(), validationEnabled);
    }

    public IssuerBuilder(IssuerFluent<?> fluent, Issuer instance) {
        this(fluent, instance, false);
    }

    public IssuerBuilder(IssuerFluent<?> fluent, Issuer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
        }
        this.validationEnabled = validationEnabled;
    }

    public IssuerBuilder(Issuer instance) {
        this(instance, (Boolean)false);
    }

    public IssuerBuilder(Issuer instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
        this.validationEnabled = validationEnabled;
    }

    public Issuer build() {
        Issuer buildable = new Issuer(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }
}

