package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PKCS12KeystoreBuilder extends PKCS12KeystoreFluentImpl<PKCS12KeystoreBuilder> implements VisitableBuilder<PKCS12Keystore,PKCS12KeystoreBuilder>{
  public PKCS12KeystoreBuilder() {
    this(false);
  }
  public PKCS12KeystoreBuilder(Boolean validationEnabled) {
    this(new PKCS12Keystore(), validationEnabled);
  }
  public PKCS12KeystoreBuilder(PKCS12KeystoreFluent<?> fluent) {
    this(fluent, false);
  }
  public PKCS12KeystoreBuilder(PKCS12KeystoreFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PKCS12Keystore(), validationEnabled);
  }
  public PKCS12KeystoreBuilder(PKCS12KeystoreFluent<?> fluent,PKCS12Keystore instance) {
    this(fluent, instance, false);
  }
  public PKCS12KeystoreBuilder(PKCS12KeystoreFluent<?> fluent,PKCS12Keystore instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCreate(instance.getCreate()); 
    fluent.withPasswordSecretRef(instance.getPasswordSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public PKCS12KeystoreBuilder(PKCS12Keystore instance) {
    this(instance,false);
  }
  public PKCS12KeystoreBuilder(PKCS12Keystore instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCreate(instance.getCreate()); 
    this.withPasswordSecretRef(instance.getPasswordSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  PKCS12KeystoreFluent<?> fluent;
  Boolean validationEnabled;
  public PKCS12Keystore build() {
    PKCS12Keystore buildable = new PKCS12Keystore(fluent.getCreate(),fluent.getPasswordSecretRef());
    return buildable;
  }
  
}