package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerDNS01ProviderRoute53FluentImpl<A extends ACMEIssuerDNS01ProviderRoute53Fluent<A>> extends BaseFluent<A> implements ACMEIssuerDNS01ProviderRoute53Fluent<A>{
  public ACMEIssuerDNS01ProviderRoute53FluentImpl() {
  }
  public ACMEIssuerDNS01ProviderRoute53FluentImpl(ACMEIssuerDNS01ProviderRoute53 instance) {
    this.withAccessKeyID(instance.getAccessKeyID()); 
    this.withHostedZoneID(instance.getHostedZoneID()); 
    this.withRegion(instance.getRegion()); 
    this.withRole(instance.getRole()); 
    this.withSecretAccessKeySecretRef(instance.getSecretAccessKeySecretRef()); 
  }
  private String accessKeyID;
  private String hostedZoneID;
  private String region;
  private String role;
  private SecretKeySelectorBuilder secretAccessKeySecretRef;
  public String getAccessKeyID() {
    return this.accessKeyID;
  }
  public A withAccessKeyID(String accessKeyID) {
    this.accessKeyID=accessKeyID; return (A) this;
  }
  public Boolean hasAccessKeyID() {
    return this.accessKeyID != null;
  }
  public String getHostedZoneID() {
    return this.hostedZoneID;
  }
  public A withHostedZoneID(String hostedZoneID) {
    this.hostedZoneID=hostedZoneID; return (A) this;
  }
  public Boolean hasHostedZoneID() {
    return this.hostedZoneID != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public String getRole() {
    return this.role;
  }
  public A withRole(String role) {
    this.role=role; return (A) this;
  }
  public Boolean hasRole() {
    return this.role != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretAccessKeySecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef!=null ?this.secretAccessKeySecretRef.build():null;
  }
  public SecretKeySelector buildSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef!=null ?this.secretAccessKeySecretRef.build():null;
  }
  public A withSecretAccessKeySecretRef(SecretKeySelector secretAccessKeySecretRef) {
    _visitables.get("secretAccessKeySecretRef").remove(this.secretAccessKeySecretRef);
    if (secretAccessKeySecretRef!=null){ this.secretAccessKeySecretRef= new SecretKeySelectorBuilder(secretAccessKeySecretRef); _visitables.get("secretAccessKeySecretRef").add(this.secretAccessKeySecretRef);} else { this.secretAccessKeySecretRef = null; _visitables.get("secretAccessKeySecretRef").remove(this.secretAccessKeySecretRef); } return (A) this;
  }
  public Boolean hasSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef != null;
  }
  public A withNewSecretAccessKeySecretRef(String key,String name) {
    return (A)withSecretAccessKeySecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerDNS01ProviderRoute53Fluent.SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRef() {
    return new ACMEIssuerDNS01ProviderRoute53FluentImpl.SecretAccessKeySecretRefNestedImpl();
  }
  public ACMEIssuerDNS01ProviderRoute53Fluent.SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return new ACMEIssuerDNS01ProviderRoute53FluentImpl.SecretAccessKeySecretRefNestedImpl(item);
  }
  public ACMEIssuerDNS01ProviderRoute53Fluent.SecretAccessKeySecretRefNested<A> editSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(getSecretAccessKeySecretRef());
  }
  public ACMEIssuerDNS01ProviderRoute53Fluent.SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(getSecretAccessKeySecretRef() != null ? getSecretAccessKeySecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEIssuerDNS01ProviderRoute53Fluent.SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return withNewSecretAccessKeySecretRefLike(getSecretAccessKeySecretRef() != null ? getSecretAccessKeySecretRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEIssuerDNS01ProviderRoute53FluentImpl that = (ACMEIssuerDNS01ProviderRoute53FluentImpl) o;
    if (accessKeyID != null ? !accessKeyID.equals(that.accessKeyID) :that.accessKeyID != null) return false;
    if (hostedZoneID != null ? !hostedZoneID.equals(that.hostedZoneID) :that.hostedZoneID != null) return false;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (role != null ? !role.equals(that.role) :that.role != null) return false;
    if (secretAccessKeySecretRef != null ? !secretAccessKeySecretRef.equals(that.secretAccessKeySecretRef) :that.secretAccessKeySecretRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessKeyID,  hostedZoneID,  region,  role,  secretAccessKeySecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessKeyID != null) { sb.append("accessKeyID:"); sb.append(accessKeyID + ","); }
    if (hostedZoneID != null) { sb.append("hostedZoneID:"); sb.append(hostedZoneID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (secretAccessKeySecretRef != null) { sb.append("secretAccessKeySecretRef:"); sb.append(secretAccessKeySecretRef); }
    sb.append("}");
    return sb.toString();
  }
  class SecretAccessKeySecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerDNS01ProviderRoute53Fluent.SecretAccessKeySecretRefNested<N>> implements ACMEIssuerDNS01ProviderRoute53Fluent.SecretAccessKeySecretRefNested<N>,Nested<N>{
    SecretAccessKeySecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretAccessKeySecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRoute53FluentImpl.this.withSecretAccessKeySecretRef(builder.build());
    }
    public N endSecretAccessKeySecretRef() {
      return and();
    }
    
  }
  
}