package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerDNS01ProviderCloudflareFluentImpl<A extends ACMEIssuerDNS01ProviderCloudflareFluent<A>> extends BaseFluent<A> implements ACMEIssuerDNS01ProviderCloudflareFluent<A>{
  public ACMEIssuerDNS01ProviderCloudflareFluentImpl() {
  }
  public ACMEIssuerDNS01ProviderCloudflareFluentImpl(ACMEIssuerDNS01ProviderCloudflare instance) {
    this.withApiKeySecretRef(instance.getApiKeySecretRef()); 
    this.withApiTokenSecretRef(instance.getApiTokenSecretRef()); 
    this.withEmail(instance.getEmail()); 
  }
  private SecretKeySelectorBuilder apiKeySecretRef;
  private SecretKeySelectorBuilder apiTokenSecretRef;
  private String email;
  
  /**
   * This method has been deprecated, please use method buildApiKeySecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getApiKeySecretRef() {
    return this.apiKeySecretRef!=null ?this.apiKeySecretRef.build():null;
  }
  public SecretKeySelector buildApiKeySecretRef() {
    return this.apiKeySecretRef!=null ?this.apiKeySecretRef.build():null;
  }
  public A withApiKeySecretRef(SecretKeySelector apiKeySecretRef) {
    _visitables.get("apiKeySecretRef").remove(this.apiKeySecretRef);
    if (apiKeySecretRef!=null){ this.apiKeySecretRef= new SecretKeySelectorBuilder(apiKeySecretRef); _visitables.get("apiKeySecretRef").add(this.apiKeySecretRef);} else { this.apiKeySecretRef = null; _visitables.get("apiKeySecretRef").remove(this.apiKeySecretRef); } return (A) this;
  }
  public Boolean hasApiKeySecretRef() {
    return this.apiKeySecretRef != null;
  }
  public A withNewApiKeySecretRef(String key,String name) {
    return (A)withApiKeySecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiKeySecretRefNested<A> withNewApiKeySecretRef() {
    return new ACMEIssuerDNS01ProviderCloudflareFluentImpl.ApiKeySecretRefNestedImpl();
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiKeySecretRefNested<A> withNewApiKeySecretRefLike(SecretKeySelector item) {
    return new ACMEIssuerDNS01ProviderCloudflareFluentImpl.ApiKeySecretRefNestedImpl(item);
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiKeySecretRefNested<A> editApiKeySecretRef() {
    return withNewApiKeySecretRefLike(getApiKeySecretRef());
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiKeySecretRefNested<A> editOrNewApiKeySecretRef() {
    return withNewApiKeySecretRefLike(getApiKeySecretRef() != null ? getApiKeySecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiKeySecretRefNested<A> editOrNewApiKeySecretRefLike(SecretKeySelector item) {
    return withNewApiKeySecretRefLike(getApiKeySecretRef() != null ? getApiKeySecretRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildApiTokenSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getApiTokenSecretRef() {
    return this.apiTokenSecretRef!=null ?this.apiTokenSecretRef.build():null;
  }
  public SecretKeySelector buildApiTokenSecretRef() {
    return this.apiTokenSecretRef!=null ?this.apiTokenSecretRef.build():null;
  }
  public A withApiTokenSecretRef(SecretKeySelector apiTokenSecretRef) {
    _visitables.get("apiTokenSecretRef").remove(this.apiTokenSecretRef);
    if (apiTokenSecretRef!=null){ this.apiTokenSecretRef= new SecretKeySelectorBuilder(apiTokenSecretRef); _visitables.get("apiTokenSecretRef").add(this.apiTokenSecretRef);} else { this.apiTokenSecretRef = null; _visitables.get("apiTokenSecretRef").remove(this.apiTokenSecretRef); } return (A) this;
  }
  public Boolean hasApiTokenSecretRef() {
    return this.apiTokenSecretRef != null;
  }
  public A withNewApiTokenSecretRef(String key,String name) {
    return (A)withApiTokenSecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiTokenSecretRefNested<A> withNewApiTokenSecretRef() {
    return new ACMEIssuerDNS01ProviderCloudflareFluentImpl.ApiTokenSecretRefNestedImpl();
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiTokenSecretRefNested<A> withNewApiTokenSecretRefLike(SecretKeySelector item) {
    return new ACMEIssuerDNS01ProviderCloudflareFluentImpl.ApiTokenSecretRefNestedImpl(item);
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiTokenSecretRefNested<A> editApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(getApiTokenSecretRef());
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(getApiTokenSecretRef() != null ? getApiTokenSecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEIssuerDNS01ProviderCloudflareFluent.ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRefLike(SecretKeySelector item) {
    return withNewApiTokenSecretRefLike(getApiTokenSecretRef() != null ? getApiTokenSecretRef(): item);
  }
  public String getEmail() {
    return this.email;
  }
  public A withEmail(String email) {
    this.email=email; return (A) this;
  }
  public Boolean hasEmail() {
    return this.email != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEIssuerDNS01ProviderCloudflareFluentImpl that = (ACMEIssuerDNS01ProviderCloudflareFluentImpl) o;
    if (apiKeySecretRef != null ? !apiKeySecretRef.equals(that.apiKeySecretRef) :that.apiKeySecretRef != null) return false;
    if (apiTokenSecretRef != null ? !apiTokenSecretRef.equals(that.apiTokenSecretRef) :that.apiTokenSecretRef != null) return false;
    if (email != null ? !email.equals(that.email) :that.email != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiKeySecretRef,  apiTokenSecretRef,  email,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiKeySecretRef != null) { sb.append("apiKeySecretRef:"); sb.append(apiKeySecretRef + ","); }
    if (apiTokenSecretRef != null) { sb.append("apiTokenSecretRef:"); sb.append(apiTokenSecretRef + ","); }
    if (email != null) { sb.append("email:"); sb.append(email); }
    sb.append("}");
    return sb.toString();
  }
  class ApiKeySecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerDNS01ProviderCloudflareFluent.ApiKeySecretRefNested<N>> implements ACMEIssuerDNS01ProviderCloudflareFluent.ApiKeySecretRefNested<N>,Nested<N>{
    ApiKeySecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    ApiKeySecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerDNS01ProviderCloudflareFluentImpl.this.withApiKeySecretRef(builder.build());
    }
    public N endApiKeySecretRef() {
      return and();
    }
    
  }
  class ApiTokenSecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerDNS01ProviderCloudflareFluent.ApiTokenSecretRefNested<N>> implements ACMEIssuerDNS01ProviderCloudflareFluent.ApiTokenSecretRefNested<N>,Nested<N>{
    ApiTokenSecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    ApiTokenSecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerDNS01ProviderCloudflareFluentImpl.this.withApiTokenSecretRef(builder.build());
    }
    public N endApiTokenSecretRef() {
      return and();
    }
    
  }
  
}