package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEIssuerDNS01ProviderAcmeDNSBuilder extends ACMEIssuerDNS01ProviderAcmeDNSFluentImpl<ACMEIssuerDNS01ProviderAcmeDNSBuilder> implements VisitableBuilder<ACMEIssuerDNS01ProviderAcmeDNS,ACMEIssuerDNS01ProviderAcmeDNSBuilder>{
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder() {
    this(false);
  }
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder(Boolean validationEnabled) {
    this(new ACMEIssuerDNS01ProviderAcmeDNS(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder(ACMEIssuerDNS01ProviderAcmeDNSFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder(ACMEIssuerDNS01ProviderAcmeDNSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEIssuerDNS01ProviderAcmeDNS(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder(ACMEIssuerDNS01ProviderAcmeDNSFluent<?> fluent,ACMEIssuerDNS01ProviderAcmeDNS instance) {
    this(fluent, instance, false);
  }
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder(ACMEIssuerDNS01ProviderAcmeDNSFluent<?> fluent,ACMEIssuerDNS01ProviderAcmeDNS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccountSecretRef(instance.getAccountSecretRef()); 
    fluent.withHost(instance.getHost()); 
    this.validationEnabled = validationEnabled; 
  }
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder(ACMEIssuerDNS01ProviderAcmeDNS instance) {
    this(instance,false);
  }
  public ACMEIssuerDNS01ProviderAcmeDNSBuilder(ACMEIssuerDNS01ProviderAcmeDNS instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccountSecretRef(instance.getAccountSecretRef()); 
    this.withHost(instance.getHost()); 
    this.validationEnabled = validationEnabled; 
  }
  ACMEIssuerDNS01ProviderAcmeDNSFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEIssuerDNS01ProviderAcmeDNS build() {
    ACMEIssuerDNS01ProviderAcmeDNS buildable = new ACMEIssuerDNS01ProviderAcmeDNS(fluent.getAccountSecretRef(),fluent.getHost());
    return buildable;
  }
  
}