package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VaultAuthBuilder extends VaultAuthFluent<VaultAuthBuilder> implements VisitableBuilder<VaultAuth,VaultAuthBuilder>{
  public VaultAuthBuilder() {
    this(new VaultAuth());
  }
  
  public VaultAuthBuilder(VaultAuthFluent<?> fluent) {
    this(fluent, new VaultAuth());
  }
  
  public VaultAuthBuilder(VaultAuthFluent<?> fluent,VaultAuth instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VaultAuthBuilder(VaultAuth instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VaultAuthFluent<?> fluent;
  
  public VaultAuth build() {
    VaultAuth buildable = new VaultAuth(fluent.buildAppRole(),fluent.buildKubernetes(),fluent.buildTokenSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}