package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ACMEIssuerBuilder extends ACMEIssuerFluent<ACMEIssuerBuilder> implements VisitableBuilder<ACMEIssuer,ACMEIssuerBuilder>{
  public ACMEIssuerBuilder() {
    this(new ACMEIssuer());
  }
  
  public ACMEIssuerBuilder(ACMEIssuerFluent<?> fluent) {
    this(fluent, new ACMEIssuer());
  }
  
  public ACMEIssuerBuilder(ACMEIssuerFluent<?> fluent,ACMEIssuer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ACMEIssuerBuilder(ACMEIssuer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ACMEIssuerFluent<?> fluent;
  
  public ACMEIssuer build() {
    ACMEIssuer buildable = new ACMEIssuer(fluent.getDisableAccountKeyGeneration(),fluent.getEmail(),fluent.getEnableDurationFeature(),fluent.buildExternalAccountBinding(),fluent.getPreferredChain(),fluent.buildPrivateKeySecretRef(),fluent.getServer(),fluent.getSkipTLSVerify(),fluent.buildSolvers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}