package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VenafiIssuerFluent<A extends VenafiIssuerFluent<A>> extends BaseFluent<A>{
  public VenafiIssuerFluent() {
  }
  
  public VenafiIssuerFluent(VenafiIssuer instance) {
    this.copyInstance(instance);
  }
  private VenafiCloudBuilder cloud;
  private VenafiTPPBuilder tpp;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VenafiIssuer instance) {
    instance = (instance != null ? instance : new VenafiIssuer());
    if (instance != null) {
          this.withCloud(instance.getCloud());
          this.withTpp(instance.getTpp());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public VenafiCloud buildCloud() {
    return this.cloud != null ? this.cloud.build() : null;
  }
  
  public A withCloud(VenafiCloud cloud) {
    this._visitables.remove("cloud");
    if (cloud != null) {
        this.cloud = new VenafiCloudBuilder(cloud);
        this._visitables.get("cloud").add(this.cloud);
    } else {
        this.cloud = null;
        this._visitables.get("cloud").remove(this.cloud);
    }
    return (A) this;
  }
  
  public boolean hasCloud() {
    return this.cloud != null;
  }
  
  public CloudNested<A> withNewCloud() {
    return new CloudNested(null);
  }
  
  public CloudNested<A> withNewCloudLike(VenafiCloud item) {
    return new CloudNested(item);
  }
  
  public CloudNested<A> editCloud() {
    return withNewCloudLike(java.util.Optional.ofNullable(buildCloud()).orElse(null));
  }
  
  public CloudNested<A> editOrNewCloud() {
    return withNewCloudLike(java.util.Optional.ofNullable(buildCloud()).orElse(new VenafiCloudBuilder().build()));
  }
  
  public CloudNested<A> editOrNewCloudLike(VenafiCloud item) {
    return withNewCloudLike(java.util.Optional.ofNullable(buildCloud()).orElse(item));
  }
  
  public VenafiTPP buildTpp() {
    return this.tpp != null ? this.tpp.build() : null;
  }
  
  public A withTpp(VenafiTPP tpp) {
    this._visitables.remove("tpp");
    if (tpp != null) {
        this.tpp = new VenafiTPPBuilder(tpp);
        this._visitables.get("tpp").add(this.tpp);
    } else {
        this.tpp = null;
        this._visitables.get("tpp").remove(this.tpp);
    }
    return (A) this;
  }
  
  public boolean hasTpp() {
    return this.tpp != null;
  }
  
  public TppNested<A> withNewTpp() {
    return new TppNested(null);
  }
  
  public TppNested<A> withNewTppLike(VenafiTPP item) {
    return new TppNested(item);
  }
  
  public TppNested<A> editTpp() {
    return withNewTppLike(java.util.Optional.ofNullable(buildTpp()).orElse(null));
  }
  
  public TppNested<A> editOrNewTpp() {
    return withNewTppLike(java.util.Optional.ofNullable(buildTpp()).orElse(new VenafiTPPBuilder().build()));
  }
  
  public TppNested<A> editOrNewTppLike(VenafiTPP item) {
    return withNewTppLike(java.util.Optional.ofNullable(buildTpp()).orElse(item));
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VenafiIssuerFluent that = (VenafiIssuerFluent) o;
    if (!java.util.Objects.equals(cloud, that.cloud)) return false;
    if (!java.util.Objects.equals(tpp, that.tpp)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cloud,  tpp,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloud != null) { sb.append("cloud:"); sb.append(cloud + ","); }
    if (tpp != null) { sb.append("tpp:"); sb.append(tpp + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CloudNested<N> extends VenafiCloudFluent<CloudNested<N>> implements Nested<N>{
    CloudNested(VenafiCloud item) {
      this.builder = new VenafiCloudBuilder(this, item);
    }
    VenafiCloudBuilder builder;
    
    public N and() {
      return (N) VenafiIssuerFluent.this.withCloud(builder.build());
    }
    
    public N endCloud() {
      return and();
    }
    
  
  }
  public class TppNested<N> extends VenafiTPPFluent<TppNested<N>> implements Nested<N>{
    TppNested(VenafiTPP item) {
      this.builder = new VenafiTPPBuilder(this, item);
    }
    VenafiTPPBuilder builder;
    
    public N and() {
      return (N) VenafiIssuerFluent.this.withTpp(builder.build());
    }
    
    public N endTpp() {
      return and();
    }
    
  
  }

}