package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderRoute53Fluent<A extends ACMEIssuerDNS01ProviderRoute53Fluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderRoute53Fluent() {
  }
  
  public ACMEIssuerDNS01ProviderRoute53Fluent(ACMEIssuerDNS01ProviderRoute53 instance) {
    this.copyInstance(instance);
  }
  private String accessKeyID;
  private String hostedZoneID;
  private String region;
  private String role;
  private SecretKeySelectorBuilder secretAccessKeySecretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderRoute53 instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderRoute53());
    if (instance != null) {
          this.withAccessKeyID(instance.getAccessKeyID());
          this.withHostedZoneID(instance.getHostedZoneID());
          this.withRegion(instance.getRegion());
          this.withRole(instance.getRole());
          this.withSecretAccessKeySecretRef(instance.getSecretAccessKeySecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAccessKeyID() {
    return this.accessKeyID;
  }
  
  public A withAccessKeyID(String accessKeyID) {
    this.accessKeyID = accessKeyID;
    return (A) this;
  }
  
  public boolean hasAccessKeyID() {
    return this.accessKeyID != null;
  }
  
  public String getHostedZoneID() {
    return this.hostedZoneID;
  }
  
  public A withHostedZoneID(String hostedZoneID) {
    this.hostedZoneID = hostedZoneID;
    return (A) this;
  }
  
  public boolean hasHostedZoneID() {
    return this.hostedZoneID != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getRole() {
    return this.role;
  }
  
  public A withRole(String role) {
    this.role = role;
    return (A) this;
  }
  
  public boolean hasRole() {
    return this.role != null;
  }
  
  public SecretKeySelector buildSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef != null ? this.secretAccessKeySecretRef.build() : null;
  }
  
  public A withSecretAccessKeySecretRef(SecretKeySelector secretAccessKeySecretRef) {
    this._visitables.remove("secretAccessKeySecretRef");
    if (secretAccessKeySecretRef != null) {
        this.secretAccessKeySecretRef = new SecretKeySelectorBuilder(secretAccessKeySecretRef);
        this._visitables.get("secretAccessKeySecretRef").add(this.secretAccessKeySecretRef);
    } else {
        this.secretAccessKeySecretRef = null;
        this._visitables.get("secretAccessKeySecretRef").remove(this.secretAccessKeySecretRef);
    }
    return (A) this;
  }
  
  public boolean hasSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef != null;
  }
  
  public A withNewSecretAccessKeySecretRef(String key,String name) {
    return (A)withSecretAccessKeySecretRef(new SecretKeySelector(key, name));
  }
  
  public SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRef() {
    return new SecretAccessKeySecretRefNested(null);
  }
  
  public SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return new SecretAccessKeySecretRefNested(item);
  }
  
  public SecretAccessKeySecretRefNested<A> editSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(null));
  }
  
  public SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderRoute53Fluent that = (ACMEIssuerDNS01ProviderRoute53Fluent) o;
    if (!java.util.Objects.equals(accessKeyID, that.accessKeyID)) return false;
    if (!java.util.Objects.equals(hostedZoneID, that.hostedZoneID)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(role, that.role)) return false;
    if (!java.util.Objects.equals(secretAccessKeySecretRef, that.secretAccessKeySecretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessKeyID,  hostedZoneID,  region,  role,  secretAccessKeySecretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessKeyID != null) { sb.append("accessKeyID:"); sb.append(accessKeyID + ","); }
    if (hostedZoneID != null) { sb.append("hostedZoneID:"); sb.append(hostedZoneID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (secretAccessKeySecretRef != null) { sb.append("secretAccessKeySecretRef:"); sb.append(secretAccessKeySecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretAccessKeySecretRefNested<N> extends SecretKeySelectorFluent<SecretAccessKeySecretRefNested<N>> implements Nested<N>{
    SecretAccessKeySecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRoute53Fluent.this.withSecretAccessKeySecretRef(builder.build());
    }
    
    public N endSecretAccessKeySecretRef() {
      return and();
    }
    
  
  }

}