package io.fabric8.certmanager.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertmanagerSchemaBuilder extends CertmanagerSchemaFluent<CertmanagerSchemaBuilder> implements VisitableBuilder<CertmanagerSchema,CertmanagerSchemaBuilder>{
  public CertmanagerSchemaBuilder() {
    this(new CertmanagerSchema());
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent) {
    this(fluent, new CertmanagerSchema());
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertmanagerSchemaFluent<?> fluent;
  
  public CertmanagerSchema build() {
    CertmanagerSchema buildable = new CertmanagerSchema(fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEAuthorization(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolver(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverDNS01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01GatewayHTTPRoute(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01Ingress(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01IngressObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01IngressPodObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01IngressPodSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01IngressPodTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEChallengeSolverHTTP01IngressTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEExternalAccountBinding(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderAcmeDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderAkamai(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderAzureDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderCloudDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderCloudflare(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderDigitalOcean(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderRFC2136(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderRoute53(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerDNS01ProviderWebhook(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ACMEIssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2AzureManagedIdentity(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2CertificateDNSNameSelector(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2Challenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ChallengeList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ChallengeSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2ChallengeStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2Order(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2OrderList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2OrderSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha2OrderStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CAIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2Certificate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateKeystores(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificatePrivateKey(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateRequest(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateRequestCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateRequestList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateRequestSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateRequestStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateSecretTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2CertificateStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2ClusterIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2ClusterIssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2Issuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2IssuerCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2IssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2IssuerSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2IssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2JKSKeystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2PKCS12Keystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2SelfSignedIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2VaultAppRole(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2VaultAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2VaultIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2VaultKubernetesAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2VenafiCloud(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2VenafiIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2VenafiTPP(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha2X509Subject(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    return buildable;
  }
  

}